<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddBiodataNewFields extends Migration
{
    public function up()
    {
        $this->forge->addColumn('biodata', [
            'jenis_kelamin' => [
                'type'       => 'ENUM',
                'constraint' => ['Laki-laki', 'Perempuan'],
                'null'       => true,
                'after'      => 'nama_lengkap',
            ],
            'tempat_lahir' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => true,
                'after'      => 'jenis_kelamin',
            ],
            'tanggal_lahir' => [
                'type' => 'DATE',
                'null' => true,
                'after' => 'tempat_lahir',
            ],
            'agama' => [
                'type'       => 'VARCHAR',
                'constraint' => 50,
                'null'       => true,
                'after'      => 'tanggal_lahir',
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('biodata', ['jenis_kelamin', 'tempat_lahir', 'tanggal_lahir', 'agama']);
    }
}
