<?php

namespace App\Models;

use CodeIgniter\Model;

class BiodataModel extends Model
{
    protected $table            = 'biodata';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_lengkap', 'jenis_kelamin', 'tempat_lahir', 'tanggal_lahir', 'agama', 'alamat', 'email', 'no_hp', 'deskripsi_diri', 'foto', 'is_active'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'nama_lengkap' => 'required|min_length[3]|max_length[100]',
        'alamat'       => 'required',
        'email'        => 'required|valid_email',
        'no_hp'        => 'required|min_length[10]|max_length[20]',
    ];

    protected $validationMessages = [
        'nama_lengkap' => [
            'required'   => 'Nama lengkap wajib diisi.',
            'min_length' => 'Nama minimal 3 karakter.',
        ],
        'alamat' => [
            'required' => 'Alamat wajib diisi.',
        ],
        'email' => [
            'required'    => 'Email wajib diisi.',
            'valid_email' => 'Format email tidak valid.',
        ],
        'no_hp' => [
            'required'   => 'Nomor HP wajib diisi.',
            'min_length' => 'Nomor HP minimal 10 digit.',
        ],
    ];

    protected $skipValidation = false;

    /**
     * Get active biodata or first if none active
     */
    public function getBiodata()
    {
        $active = $this->where('is_active', 1)->first();
        if ($active) {
            return $active;
        }
        return $this->first();
    }
}
