<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in max-w-3xl">
    <!-- Back Button -->
    <a href="<?= base_url('admin/aktivitas') ?>" class="inline-flex items-center text-slate-500 hover:text-slate-800 mb-6 transition-colors">
        <i class="fas fa-arrow-left mr-2"></i>
        Kembali ke Daftar Aktivitas
    </a>

    <!-- Form Card -->
    <div class="bg-white border border-slate-200 rounded-2xl p-6 shadow-sm">
        <h2 class="text-xl font-bold mb-6 flex items-center text-slate-800">
            <i class="fas fa-edit text-blue-600 mr-3"></i>
            Edit Aktivitas
        </h2>

        <form action="<?= base_url('admin/aktivitas/update/' . $aktivitas['id']) ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?= csrf_field() ?>

            <!-- Tanggal & Jam -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="tanggal" class="block text-sm font-medium text-slate-600 mb-2">
                        <i class="far fa-calendar mr-2"></i>Tanggal <span class="text-red-500">*</span>
                    </label>
                    <input type="date" 
                           id="tanggal" 
                           name="tanggal" 
                           value="<?= old('tanggal') ?? $aktivitas['tanggal'] ?>"
                           class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm"
                           required>
                </div>
                <div>
                    <label for="jam" class="block text-sm font-medium text-slate-600 mb-2">
                        <i class="far fa-clock mr-2"></i>Jam <span class="text-red-500">*</span>
                    </label>
                    <input type="time" 
                           id="jam" 
                           name="jam" 
                           value="<?= old('jam') ?? $aktivitas['jam'] ?>"
                           class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm"
                           required>
                </div>
            </div>

            <!-- Nama Aktivitas -->
            <div>
                <label for="nama_aktivitas" class="block text-sm font-medium text-slate-600 mb-2">
                    <i class="fas fa-tasks mr-2"></i>Nama Aktivitas <span class="text-red-500">*</span>
                </label>
                <input type="text" 
                       id="nama_aktivitas" 
                       name="nama_aktivitas" 
                       value="<?= old('nama_aktivitas') ?? $aktivitas['nama_aktivitas'] ?>"
                       class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm"
                       placeholder="Masukkan nama aktivitas..."
                       required>
            </div>

            <!-- Deskripsi -->
            <div>
                <label for="deskripsi" class="block text-sm font-medium text-slate-600 mb-2">
                    <i class="fas fa-align-left mr-2"></i>Deskripsi
                </label>
                <textarea id="deskripsi" 
                          name="deskripsi" 
                          rows="4"
                          class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm resize-none"
                          placeholder="Deskripsi aktivitas (opsional)..."><?= old('deskripsi') ?? $aktivitas['deskripsi'] ?></textarea>
            </div>

            <!-- Current Media -->
            <?php if (!empty($aktivitas['foto']) || !empty($aktivitas['video'])): ?>
                <div class="bg-slate-50 rounded-lg p-4 border border-slate-200">
                    <h3 class="text-sm font-medium text-slate-600 mb-3">Media Saat Ini</h3>
                    <div class="space-y-4">
                        <?php if (!empty($aktivitas['foto'])): ?>
                            <div class="flex items-center justify-between bg-white rounded-lg p-3 border border-slate-100 shadow-sm">
                                <div class="flex items-center space-x-4">
                                    <img src="<?= base_url('assets/uploads/aktivitas/' . $aktivitas['foto']) ?>" 
                                         alt="Foto" 
                                         class="h-16 w-16 object-cover rounded-lg border border-slate-200">
                                    <div>
                                        <span class="text-emerald-500 text-sm font-medium"><i class="fas fa-image mr-1"></i>Foto</span>
                                        <p class="text-slate-500 text-xs"><?= $aktivitas['foto'] ?></p>
                                    </div>
                                </div>
                                <label class="flex items-center space-x-2 text-red-500 cursor-pointer hover:text-red-600">
                                    <input type="checkbox" name="hapus_foto" value="1" class="w-4 h-4 rounded border-slate-300 bg-white text-red-500 focus:ring-red-500">
                                    <span class="text-sm"><i class="fas fa-trash mr-1"></i>Hapus</span>
                                </label>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($aktivitas['video'])): ?>
                            <div class="flex items-center justify-between bg-white rounded-lg p-3 border border-slate-100 shadow-sm">
                                <div class="flex items-center space-x-4">
                                    <div class="h-16 w-16 bg-purple-50 rounded-lg flex items-center justify-center border border-purple-100">
                                        <i class="fas fa-video text-2xl text-purple-500"></i>
                                    </div>
                                    <div>
                                        <span class="text-purple-500 text-sm font-medium"><i class="fas fa-video mr-1"></i>Video</span>
                                        <p class="text-slate-500 text-xs"><?= $aktivitas['video'] ?></p>
                                    </div>
                                </div>
                                <label class="flex items-center space-x-2 text-red-500 cursor-pointer hover:text-red-600">
                                    <input type="checkbox" name="hapus_video" value="1" class="w-4 h-4 rounded border-slate-300 bg-white text-red-500 focus:ring-red-500">
                                    <span class="text-sm"><i class="fas fa-trash mr-1"></i>Hapus</span>
                                </label>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- File Uploads -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Foto -->
                <div>
                    <label for="foto" class="block text-sm font-medium text-slate-600 mb-2">
                        <i class="fas fa-image mr-2"></i>Ganti Foto
                    </label>
                    <input type="file" 
                           id="foto" 
                           name="foto" 
                           accept="image/*"
                           onchange="previewImage(this, 'fotoPreview')"
                           class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-blue-100 file:text-blue-700 hover:file:bg-blue-200 cursor-pointer shadow-sm">
                    <p class="text-xs text-slate-500 mt-2">Kosongkan jika tidak ingin mengganti</p>
                    <img id="fotoPreview" src="" alt="Preview" class="hidden mt-3 max-h-40 rounded-lg border border-slate-200 shadow-sm">
                </div>

                <!-- Video -->
                <div>
                    <label for="video" class="block text-sm font-medium text-slate-600 mb-2">
                        <i class="fas fa-video mr-2"></i>Ganti Video
                    </label>
                    <input type="file" 
                           id="video" 
                           name="video" 
                           accept="video/*"
                           class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-purple-100 file:text-purple-700 hover:file:bg-purple-200 cursor-pointer shadow-sm">
                    <p class="text-xs text-slate-500 mt-2">Kosongkan jika tidak ingin mengganti</p>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="flex items-center justify-end space-x-4 pt-4 border-t border-slate-100">
                <a href="<?= base_url('admin/aktivitas') ?>" class="px-6 py-3 bg-slate-100 hover:bg-slate-200 rounded-lg text-slate-600 transition-colors">
                    Batal
                </a>
                <button type="submit" class="btn-primary px-6 py-3 rounded-lg text-white font-medium shadow-lg shadow-sky-500/30">
                    <i class="fas fa-save mr-2"></i>
                    Update Aktivitas
                </button>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
