<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Panel' ?> - Portfolio Mahasiswa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
</head>
<body class="bg-sky-50 text-slate-800 min-h-screen">
    <!-- Mobile Sidebar Overlay -->
    <div id="sidebarOverlay" class="fixed inset-0 bg-slate-900/50 z-40 hidden md:hidden glass"></div>

    <div class="flex min-h-screen">
        <!-- Sidebar -->
        <aside id="sidebar" class="fixed md:static inset-y-0 left-0 z-50 w-64 bg-white border-r border-sky-100 shadow-lg transform -translate-x-full md:translate-x-0 transition-transform duration-300">
            <!-- Logo -->
            <div class="flex items-center justify-center h-20 border-b border-sky-100">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-sky-500 to-blue-600 rounded-lg flex items-center justify-center shadow-md">
                        <i class="fas fa-graduation-cap text-white"></i>
                    </div>
                    <span class="text-xl font-bold bg-gradient-to-r from-sky-600 to-blue-600 bg-clip-text text-transparent">Admin Panel</span>
                </div>
            </div>

            <!-- User Info -->
            <div class="px-6 py-4 border-b border-sky-100 bg-sky-50/50">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-green-400 to-emerald-500 rounded-full flex items-center justify-center shadow-sm">
                        <i class="fas fa-user text-white"></i>
                    </div>
                    <div>
                        <p class="font-medium text-slate-800"><?= session()->get('userName') ?? 'Admin' ?></p>
                        <p class="text-xs text-slate-500"><?= session()->get('userEmail') ?? 'admin@example.com' ?></p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="p-4 space-y-2">
                <a href="<?= base_url('admin') ?>" 
                   class="sidebar-link flex items-center px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 <?= current_url() == base_url('admin') || current_url() == base_url('admin/dashboard') ? 'active font-semibold bg-sky-50 text-sky-600' : '' ?>">
                    <i class="fas fa-tachometer-alt w-5 mr-3"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="<?= base_url('admin/aktivitas') ?>" 
                   class="sidebar-link flex items-center px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 <?= strpos(current_url(), 'admin/aktivitas') !== false ? 'active font-semibold bg-sky-50 text-sky-600' : '' ?>">
                    <i class="fas fa-calendar-day w-5 mr-3"></i>
                    <span>Aktivitas Harian</span>
                </a>
                
                <a href="<?= base_url('admin/biodata') ?>" 
                   class="sidebar-link flex items-center px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 <?= strpos(current_url(), 'admin/biodata') !== false ? 'active font-semibold bg-sky-50 text-sky-600' : '' ?>">
                    <i class="fas fa-id-card w-5 mr-3"></i>
                    <span>Biodata / CV</span>
                </a>
                
                <a href="<?= base_url('admin/pendidikan') ?>" 
                   class="sidebar-link flex items-center px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50 <?= strpos(current_url(), 'admin/pendidikan') !== false ? 'active font-semibold bg-sky-50 text-sky-600' : '' ?>">
                    <i class="fas fa-graduation-cap w-5 mr-3"></i>
                    <span>Riwayat Pendidikan</span>
                </a>

                <div class="border-t border-sky-100 my-4"></div>

                <a href="<?= base_url('/') ?>" 
                   class="sidebar-link flex items-center px-4 py-3 rounded-lg text-slate-600 hover:text-sky-600 hover:bg-sky-50">
                    <i class="fas fa-globe w-5 mr-3"></i>
                    <span>Lihat Website</span>
                </a>
                
                <a href="<?= base_url('logout') ?>" 
                   class="sidebar-link flex items-center px-4 py-3 rounded-lg text-red-500 hover:text-red-600 hover:bg-red-50">
                    <i class="fas fa-sign-out-alt w-5 mr-3"></i>
                    <span>Logout</span>
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 flex flex-col min-h-screen">
            <!-- Top Bar -->
            <header class="bg-white/80 backdrop-blur-lg border-b border-sky-100 px-6 py-4 sticky top-0 z-30 shadow-sm">
                <div class="flex items-center justify-between">
                    <!-- Mobile Menu Toggle -->
                    <button onclick="toggleSidebar()" class="md:hidden p-2 rounded-lg hover:bg-sky-50 text-slate-600 transition-colors">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    
                    <h1 class="text-xl font-semibold text-slate-800"><?= $title ?? 'Dashboard' ?></h1>
                    
                    <div class="flex items-center space-x-4">
                        <span class="text-sm text-slate-500 bg-sky-50 px-3 py-1 rounded-full border border-sky-100">
                            <i class="far fa-clock mr-1"></i>
                            <?php date_default_timezone_set('Asia/Jakarta'); ?>
                            <?= date('d M Y, H:i') ?> WIB
                        </span>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <div class="flex-1 p-6 overflow-auto">
                <!-- Alert Messages -->
                <?php if (session()->getFlashdata('success')): ?>
                    <div class="alert-dismissible bg-green-50 border border-green-200 text-green-800 px-6 py-4 rounded-lg mb-6 animate-fade-in shadow-sm">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-xl mr-3 text-green-500"></i>
                            <span><?= session()->getFlashdata('success') ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('error')): ?>
                    <div class="alert-dismissible bg-red-50 border border-red-200 text-red-800 px-6 py-4 rounded-lg mb-6 animate-shake shadow-sm">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-xl mr-3 text-red-500"></i>
                            <span><?= session()->getFlashdata('error') ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('errors')): ?>
                    <div class="alert-dismissible bg-red-50 border border-red-200 text-red-800 px-6 py-4 rounded-lg mb-6 shadow-sm">
                        <div class="flex items-start">
                            <i class="fas fa-exclamation-triangle text-xl mr-3 mt-1 text-red-500"></i>
                            <ul class="list-disc list-inside">
                                <?php foreach (session()->getFlashdata('errors') as $error): ?>
                                    <li><?= esc($error) ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Dynamic Content -->
                <?= $this->renderSection('content') ?>
            </div>

            <!-- Footer -->
            <footer class="bg-white border-t border-sky-100 px-6 py-4 text-center text-slate-400 text-sm">
                <p>&copy; 2025 Portfolio Rohani</p>
            </footer>
        </main>
    </div>

    <!-- Delete Confirmation Modal -->
    <div id="deleteModal" class="fixed inset-0 z-50 hidden items-center justify-center modal-overlay">
        <div class="modal-content bg-white rounded-2xl shadow-2xl p-6 max-w-md w-full mx-4 border border-sky-100">
            <div class="text-center">
                <div class="w-16 h-16 bg-red-50 rounded-full flex items-center justify-center mx-auto mb-4 border border-red-100">
                    <i class="fas fa-trash-alt text-3xl text-red-500"></i>
                </div>
                <h3 class="text-xl font-bold mb-2 text-slate-800">Konfirmasi Hapus</h3>
                <p class="text-slate-500 mb-6">Apakah Anda yakin ingin menghapus <span id="deleteItemName" class="font-semibold text-slate-700">data ini</span>? Tindakan ini tidak dapat dibatalkan.</p>
                <div class="flex space-x-4 justify-center">
                    <button onclick="closeDeleteModal()" class="px-6 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 rounded-lg transition-colors font-medium">
                        Batal
                    </button>
                    <button id="confirmDeleteBtn" class="px-6 py-2 bg-red-500 hover:bg-red-600 text-white rounded-lg transition-colors font-medium shadow-md shadow-red-500/30">
                        Ya, Hapus
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="<?= base_url('assets/js/app.js') ?>"></script>
</body>
</html>
