<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in max-w-3xl">
    <a href="<?= base_url('admin/pendidikan') ?>" class="inline-flex items-center text-slate-500 hover:text-slate-800 mb-6 transition-colors">
        <i class="fas fa-arrow-left mr-2"></i>Kembali
    </a>

    <div class="bg-white border border-slate-200 rounded-2xl p-6 shadow-sm">
        <h2 class="text-xl font-bold mb-6 flex items-center text-slate-800">
            <i class="fas fa-edit text-blue-600 mr-3"></i>Edit Riwayat Pendidikan
        </h2>

        <form action="<?= base_url('admin/pendidikan/update/' . $pendidikan['id']) ?>" method="POST" class="space-y-6">
            <?= csrf_field() ?>

            <div>
                <label for="jenjang" class="block text-sm font-medium text-slate-600 mb-2">Jenjang <span class="text-red-500">*</span></label>
                <select id="jenjang" name="jenjang" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent transition-all shadow-sm" required>
                    <?php foreach ($jenjangOptions as $option): ?>
                        <option value="<?= $option ?>" <?= (old('jenjang') ?? $pendidikan['jenjang']) == $option ? 'selected' : '' ?>><?= $option ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div>
                <label for="nama_sekolah" class="block text-sm font-medium text-slate-600 mb-2">Nama Sekolah/Universitas <span class="text-red-500">*</span></label>
                <input type="text" id="nama_sekolah" name="nama_sekolah" value="<?= old('nama_sekolah') ?? $pendidikan['nama_sekolah'] ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="tahun_masuk" class="block text-sm font-medium text-slate-600 mb-2">Tahun Masuk <span class="text-red-500">*</span></label>
                    <input type="number" id="tahun_masuk" name="tahun_masuk" value="<?= old('tahun_masuk') ?? $pendidikan['tahun_masuk'] ?>" min="1990" max="<?= date('Y') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent transition-all shadow-sm" required>
                </div>
                <div>
                    <label for="tahun_lulus" class="block text-sm font-medium text-slate-600 mb-2">Tahun Lulus</label>
                    <input type="number" id="tahun_lulus" name="tahun_lulus" value="<?= old('tahun_lulus') ?? $pendidikan['tahun_lulus'] ?>" min="1990" max="<?= date('Y') + 10 ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent transition-all shadow-sm">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="jurusan" class="block text-sm font-medium text-slate-600 mb-2">Jurusan/Program Studi</label>
                    <input type="text" id="jurusan" name="jurusan" value="<?= old('jurusan') ?? $pendidikan['jurusan'] ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent transition-all shadow-sm">
                </div>
                <div>
                    <label for="nilai_akhir" class="block text-sm font-medium text-slate-600 mb-2">Nilai Akhir/IPK</label>
                    <input type="text" id="nilai_akhir" name="nilai_akhir" value="<?= old('nilai_akhir') ?? $pendidikan['nilai_akhir'] ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent transition-all shadow-sm">
                </div>
            </div>

            <div class="flex justify-end space-x-4 pt-4 border-t border-slate-100">
                <a href="<?= base_url('admin/pendidikan') ?>" class="px-6 py-3 bg-slate-100 rounded-lg text-slate-600 hover:bg-slate-200 transition-colors">Batal</a>
                <button type="submit" class="btn-primary px-6 py-3 rounded-lg text-white font-medium shadow-lg shadow-purple-500/30"><i class="fas fa-save mr-2"></i>Update</button>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
