<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6 gap-4">
        <div>
            <h2 class="text-2xl font-bold text-slate-800">Riwayat Pendidikan</h2>
            <p class="text-slate-500">Kelola riwayat pendidikan dari SD hingga Kuliah</p>
        </div>
        <a href="<?= base_url('admin/pendidikan/create') ?>" class="inline-flex items-center px-6 py-3 rounded-xl text-white font-medium bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 transition-all shadow-lg shadow-purple-500/30">
            <i class="fas fa-plus mr-2"></i>Tambah Pendidikan
        </a>
    </div>

    <?php if (!empty($pendidikan)): ?>
        <div class="bg-white border border-slate-200 rounded-2xl overflow-hidden shadow-sm">
            <div class="overflow-x-auto">
                <table class="table-modern w-full">
                    <thead class="bg-slate-50">
                        <tr>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">No</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Jenjang</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Nama Sekolah/Universitas</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Tahun</th>
                            <th class="px-6 py-4 text-left text-slate-600 font-semibold">Jurusan</th>
                            <th class="px-6 py-4 text-center text-slate-600 font-semibold">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        <?php $no = 1; foreach ($pendidikan as $item): ?>
                            <tr class="hover:bg-slate-50 transition-colors">
                                <td class="px-6 py-4 text-slate-500"><?= $no++ ?></td>
                                <td class="px-6 py-4">
                                    <?php 
                                    $colors = [
                                        'SD' => 'bg-green-100 text-green-600',
                                        'SMP' => 'bg-blue-100 text-blue-600',
                                        'SMA' => 'bg-yellow-100 text-yellow-600',
                                        'Kuliah' => 'bg-purple-100 text-purple-600',
                                    ];
                                    $colorClass = $colors[$item['jenjang']] ?? 'bg-slate-100 text-slate-500';
                                    ?>
                                    <span class="<?= $colorClass ?> px-3 py-1 rounded-full text-sm font-medium">
                                        <?= $item['jenjang'] ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-slate-800 font-medium"><?= esc($item['nama_sekolah']) ?></td>
                                <td class="px-6 py-4 text-slate-500">
                                    <?= $item['tahun_masuk'] ?> - <?= $item['tahun_lulus'] ?? 'Sekarang' ?>
                                </td>
                                <td class="px-6 py-4 text-slate-500"><?= esc($item['jurusan']) ?: '-' ?></td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center justify-center space-x-2">
                                        <a href="<?= base_url('admin/pendidikan/edit/' . $item['id']) ?>" class="p-2 bg-blue-100 text-blue-600 rounded-lg hover:bg-blue-200 transition-colors">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form id="deleteForm<?= $item['id'] ?>" action="<?= base_url('admin/pendidikan/delete/' . $item['id']) ?>" method="POST" class="inline">
                                            <?= csrf_field() ?>
                                            <button type="button" onclick="confirmDelete('deleteForm<?= $item['id'] ?>', '<?= esc($item['nama_sekolah']) ?>')" class="p-2 bg-red-100 text-red-600 rounded-lg hover:bg-red-200 transition-colors">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-white border border-slate-200 rounded-2xl px-6 py-16 text-center shadow-sm">
            <div class="w-20 h-20 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4 text-slate-400">
                <i class="fas fa-graduation-cap text-3xl"></i>
            </div>
            <h3 class="text-xl font-medium text-slate-800 mb-2">Belum Ada Riwayat Pendidikan</h3>
            <p class="text-slate-500 mb-6">Mulai tambahkan riwayat pendidikan Anda</p>
            <a href="<?= base_url('admin/pendidikan/create') ?>" class="inline-flex items-center px-6 py-3 rounded-xl text-white font-medium bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 shadow-lg shadow-purple-500/30">
                <i class="fas fa-plus mr-2"></i>Tambah Pendidikan Pertama
            </a>
        </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>
