<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\PendidikanModel;
use App\Models\AktivitasModel;

class Home extends BaseController
{
    protected $biodataModel;
    protected $pendidikanModel;
    protected $aktivitasModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->pendidikanModel = new PendidikanModel();
        $this->aktivitasModel = new AktivitasModel();
    }

    public function index(): string
    {
        $data = [
            'title' => 'Home - Portfolio Digital',
            'biodata' => $this->biodataModel->first()
        ];
        return view('home', $data);
    }

    public function cv(): string
    {
        $data = [
            'title' => 'CV - Portfolio Digital',
            'biodata' => $this->biodataModel->first(),
            'pendidikan' => $this->pendidikanModel
                ->orderBy('tahun_selesai', 'DESC')
                ->findAll(),
        ];
        return view('cv', $data);
    }

    public function pendidikan(): string
    {
        $search  = trim((string) $this->request->getGet('q'));
        $jenjang = $this->request->getGet('jenjang');
        $sort    = $this->request->getGet('sort') ?: 'tahun_selesai';
        $dir     = strtolower($this->request->getGet('dir') ?: 'desc');

        $builder = $this->pendidikanModel;

        if ($search !== '') {
            $builder = $builder->like('institusi', $search);
        }

        if (!empty($jenjang)) {
            $builder = $builder->where('jenjang', $jenjang);
        }

        $allowedSorts = ['tahun_selesai', 'tahun_mulai', 'jenjang', 'institusi'];
        if (!in_array($sort, $allowedSorts, true)) {
            $sort = 'tahun_selesai';
        }
        $dir = $dir === 'asc' ? 'asc' : 'desc';

        // Custom ordering for jenjang supaya runtut (SD -> SMP -> SMA -> S1 -> S2 -> S3)
        if ($sort === 'jenjang') {
            $caseJenjang = "CASE jenjang "
                . "WHEN 'PAUD' THEN 0 "
                . "WHEN 'TK' THEN 1 "
                . "WHEN 'SD' THEN 2 "
                . "WHEN 'SMP' THEN 3 "
                . "WHEN 'SMA' THEN 4 "
                . "WHEN 'SMK' THEN 4 "
                . "WHEN 'D3' THEN 5 "
                . "WHEN 'S1' THEN 6 "
                . "WHEN 'S2' THEN 7 "
                . "WHEN 'S3' THEN 8 "
                . "ELSE 99 END";

            $builder = $builder
                ->orderBy($caseJenjang, $dir)
                ->orderBy('tahun_mulai', $dir)
                ->orderBy('tahun_selesai', $dir)
                ->orderBy('id', 'asc');
        } else {
            $builder = $builder
                ->orderBy($sort, $dir)
                ->orderBy('tahun_mulai', $dir)
                ->orderBy('id', 'asc');
        }

        $perPage    = 10;
        $pendidikan = $builder->paginate($perPage, 'pendidikan_front');
        $pager      = $this->pendidikanModel->pager;

        $data = [
            'title' => 'Pendidikan - Portfolio Digital',
            'pendidikan' => $pendidikan,
            'pager'      => $pager,
            'search'     => $search,
            'filter_jenjang' => $jenjang,
            'sort'       => $sort,
            'dir'        => $dir,
        ];
        return view('pendidikan', $data);
    }

    public function aktivitas(): string
    {
        $search = trim((string) $this->request->getGet('q'));
        $jenis  = $this->request->getGet('jenis');
        $sort   = $this->request->getGet('sort') ?: 'tanggal';
        $dir    = strtolower($this->request->getGet('dir') ?: 'desc');

        $builder = $this->aktivitasModel;

        if ($search !== '') {
            $builder = $builder->like('nama_aktivitas', $search);
        }

        if (!empty($jenis)) {
            $builder = $builder->where('jenis', $jenis);
        }

        $allowedSorts = ['tanggal', 'jam', 'nama_aktivitas', 'id'];
        if (!in_array($sort, $allowedSorts, true)) {
            $sort = 'tanggal';
        }
        $dir = $dir === 'asc' ? 'asc' : 'desc';

        $builder = $builder->orderBy($sort, $dir);
        if ($sort !== 'jam') {
            $builder = $builder->orderBy('jam', $dir);
        }

        $perPage    = 10;
        $aktivitas  = $builder->paginate($perPage, 'aktivitas_front');
        $pager      = $this->aktivitasModel->pager;

        $data = [
            'title' => 'Aktivitas - Portfolio Digital',
            'aktivitas' => $aktivitas,
            'pager'     => $pager,
            'search'    => $search,
            'filter_jenis' => $jenis,
            'sort'      => $sort,
            'dir'       => $dir,
        ];
        return view('aktivitas', $data);
    }
}
