<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: linear-gradient(135deg, rgba(15,23,42,0.92), rgba(30,64,175,0.9));
        padding: 2rem;
        border-radius: 18px;
        margin-bottom: 2rem;
        box-shadow: 0 20px 55px rgba(0,0,0,0.35);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
        border: 1px solid rgba(148,163,184,0.4);
    }
    .admin-header h1 {
        color: #f8fafc;
        margin: 0;
    }
    .admin-header .btn {
        box-shadow: 0 10px 30px rgba(37,99,235,0.35);
    }
    .admin-filters .form-control {
        background: rgba(15,23,42,0.9);
        color: #e5e7eb;
        border: 1px solid rgba(148,163,184,0.6);
        box-shadow: 0 10px 30px rgba(0,0,0,0.35);
    }
    .admin-filters .form-control::placeholder {
        color: #cbd5f5;
    }
    .admin-filters .form-control option {
        color: #0f172a;
        background: #e5e7eb;
    }
    .table-container {
        background: linear-gradient(135deg, rgba(15,23,42,0.94), rgba(30,64,175,0.9));
        border: 1px solid rgba(148,163,184,0.35);
        box-shadow: 0 22px 60px rgba(0,0,0,0.4);
    }
    .table-container table {
        color: #e5e7eb;
    }
    .table-container table th {
        background: rgba(15,23,42,0.85);
        color: #e5e7eb;
        border-bottom: 1px solid rgba(148,163,184,0.4);
    }
    .table-container table td {
        color: #e5e7eb;
        border-bottom: 1px solid rgba(148,163,184,0.2);
    }
    .table-container table tr:hover {
        background: rgba(59,130,246,0.08);
    }
    .alert-success {
        background: rgba(16,185,129,0.16);
        color: #bbf7d0;
        padding: 1rem;
        border-radius: 10px;
        margin-bottom: 1rem;
        border: 1px solid rgba(52,211,153,0.4);
    }
    .action-btn {
        padding: 6px 16px;
        font-size: 0.9rem;
        border: none;
        color: #f8fafc;
        border-radius: 12px;
        cursor: pointer;
        transition: transform 0.2s, box-shadow 0.25s, opacity 0.2s;
    }
    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 26px rgba(0,0,0,0.25);
    }
    .action-btn:active {
        transform: translateY(0);
        opacity: 0.9;
    }
    .admin-edit-btn {
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
    }
    .admin-delete-btn {
        background: linear-gradient(135deg, #ef4444, #f97316);
    }
    .apply-btn {
        padding: 8px 18px;
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
        color: #f8fafc;
        border: none;
        border-radius: 12px;
        box-shadow: 0 10px 26px rgba(37,99,235,0.35);
    }
</style>

<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-user"></i> Kelola Biodata</h1>
            <div>
                <a href="<?= base_url('admin') ?>" class="btn" style="padding: 10px 20px; margin-right: 10px;">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                <a href="<?= base_url('admin/biodata/create') ?>" class="btn" style="padding: 10px 20px;">
                    <i class="fas fa-plus"></i> Tambah Biodata
                </a>
            </div>
        </div>

        <form method="GET" class="admin-filters" style="margin-bottom: 1rem; display: flex; flex-wrap: wrap; gap: 0.75rem; align-items: center;">
            <input type="text" name="q" class="form-control" placeholder="Cari nama atau email..." value="<?= esc($search ?? '') ?>" style="max-width: 260px;">
            <select name="sort" class="form-control" style="max-width: 180px;">
                <option value="nama" <?= ($sort ?? '') === 'nama' ? 'selected' : '' ?>>Urutkan: Nama</option>
                <option value="email" <?= ($sort ?? '') === 'email' ? 'selected' : '' ?>>Urutkan: Email</option>
                <option value="id" <?= ($sort ?? '') === 'id' ? 'selected' : '' ?>>Urutkan: ID</option>
            </select>
            <select name="dir" class="form-control" style="max-width: 150px;">
                <option value="asc" <?= ($dir ?? '') === 'asc' ? 'selected' : '' ?>>Naik (ASC)</option>
                <option value="desc" <?= ($dir ?? '') === 'desc' ? 'selected' : '' ?>>Turun (DESC)</option>
            </select>
            <button type="submit" class="apply-btn">Terapkan</button>
        </form>

        <?php if (session()->getFlashdata('success')): ?>
        <div class="alert-success">
            <i class="fas fa-check-circle"></i> <?= session()->getFlashdata('success') ?>
        </div>
        <?php endif; ?>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>Telepon</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($biodata)): ?>
                        <?php foreach ($biodata as $item): ?>
                        <tr>
                            <td><?= esc($item['id']) ?></td>
                            <td><?= esc($item['nama']) ?></td>
                            <td><?= esc($item['email']) ?></td>
                            <td><?= esc($item['telepon']) ?></td>
                            <td>
                                <a href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>" class="action-btn admin-edit-btn" style="margin-right: 6px;">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form method="POST" action="<?= base_url('admin/biodata/delete/' . $item['id']) ?>" style="display:inline;">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="action-btn admin-delete-btn" onclick="return confirm('Yakin ingin menghapus?')">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" style="text-align: center; padding: 2rem; color: #64748b;">
                                Belum ada data biodata
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <?php if (isset($pager)): ?>
            <div class="pagination" style="margin-top: 1rem;">
                <?= $pager->links('biodata', 'default_full') ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?= $this->endSection() ?>

