<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<section style="padding-top: 100px;">
    <div class="container" style="max-width: 1200px;">
        <h2 class="section-title" style="text-align: left; margin-left: 0;">Aktivitas</h2>
        <style>
            .aktivitas-filters .form-control {
                background: rgba(15,23,42,0.9);
                color: #e5e7eb;
                border: 1px solid rgba(148,163,184,0.7);
                box-shadow: 0 8px 24px rgba(15,23,42,0.6);
            }
            .aktivitas-filters .form-control::placeholder {
                color: #cbd5f5;
            }
            .aktivitas-filters .form-control option {
                color: #0f172a;
                background: #e5e7eb;
            }
            .gallery {
                align-items: stretch;
            }
            .gallery-item {
                position: relative;
                display: flex;
                flex-direction: column;
                gap: 0.65rem;
                text-decoration: none;
                color: #e5e7eb;
                background: rgba(15,23,42,0.92);
                border-radius: 18px;
                padding: 0.8rem;
                border: 1px solid rgba(148,163,184,0.4);
                box-shadow: 0 16px 40px rgba(0,0,0,0.35);
                transition: transform 0.25s, box-shadow 0.25s, border-color 0.25s;
            }
            .gallery-item:hover {
                transform: translateY(-4px);
                box-shadow: 0 20px 45px rgba(0,0,0,0.4);
                border-color: rgba(59,130,246,0.6);
            }
            .gallery-media {
                border-radius: 14px;
                overflow: hidden;
                aspect-ratio: 16 / 9;
                background: #0f172a;
            }
            .gallery-media img,
            .gallery-media video {
                width: 100%;
                height: 100%;
                object-fit: cover;
                display: block;
                transition: transform 0.3s;
            }
            .gallery-item:hover .gallery-media img,
            .gallery-item:hover .gallery-media video {
                transform: scale(1.02);
            }
            .gallery-caption {
                padding: 0 0.35rem 0.4rem;
                display: flex;
                flex-direction: column;
                gap: 0.25rem;
            }
            .gallery-title {
                margin: 0;
                font-size: 1.05rem;
                font-weight: 600;
                color: #f8fafc;
            }
            .gallery-meta {
                margin: 0;
                font-size: 0.9rem;
                color: #cbd5f5;
                display: flex;
                align-items: center;
                gap: 0.65rem;
                flex-wrap: wrap;
            }
            .gallery-desc {
                margin: 0;
                font-size: 0.9rem;
                color: #e2e8f0;
            }
            .gallery-overlay {
                display: none !important;
            }
        </style>

        <form method="GET" class="aktivitas-filters" style="margin-bottom: 1rem; display: flex; flex-wrap: wrap; gap: 0.75rem; align-items: center;">
            <input type="text" name="q" class="form-control" placeholder="Cari aktivitas..." value="<?= esc($search ?? '') ?>" style="max-width: 260px;">
            <select name="jenis" class="form-control" style="max-width: 160px;">
                <option value="">Semua Jenis</option>
                <option value="foto" <?= ($filter_jenis ?? '') === 'foto' ? 'selected' : '' ?>>Foto</option>
                <option value="video" <?= ($filter_jenis ?? '') === 'video' ? 'selected' : '' ?>>Video</option>
            </select>
            <select name="sort" class="form-control" style="max-width: 200px;">
                <option value="tanggal" <?= ($sort ?? '') === 'tanggal' ? 'selected' : '' ?>>Urutkan: Tanggal</option>
                <option value="nama_aktivitas" <?= ($sort ?? '') === 'nama_aktivitas' ? 'selected' : '' ?>>Urutkan: Nama</option>
            </select>
            <select name="dir" class="form-control" style="max-width: 150px;">
                <option value="desc" <?= ($dir ?? '') === 'desc' ? 'selected' : '' ?>>Terbaru &rarr; Lama</option>
                <option value="asc" <?= ($dir ?? '') === 'asc' ? 'selected' : '' ?>>Lama &rarr; Terbaru</option>
            </select>
            <button type="submit" class="btn" style="padding: 8px 18px;">Terapkan</button>
        </form>

        <?php if (!empty($aktivitas)): ?>
        <div class="gallery">
            <?php foreach ($aktivitas as $item): ?>
            <?php
                $path = $item['file_path'] ?? '';
                if (!empty($path) && strpos($path, '/') === false) {
                    $path = 'uploads/' . $path;
                }
                $mediaUrl = !empty($path) ? base_url(esc($path)) : '';
            ?>
            <a class="gallery-item" href="<?= $mediaUrl ?>" target="_blank" rel="noopener">
                <div class="gallery-media">
                    <?php if ($item['jenis'] === 'foto' && !empty($path)): ?>
                        <img src="<?= $mediaUrl ?>" alt="<?= esc($item['nama_aktivitas']) ?>">
                    <?php elseif ($item['jenis'] === 'video' && !empty($path)): ?>
                        <video controls>
                            <source src="<?= $mediaUrl ?>" type="video/mp4">
                            Browser Anda tidak mendukung video tag.
                        </video>
                    <?php else: ?>
                        <div style="width: 100%; height: 100%; background: var(--gradient); display: flex; align-items: center; justify-content: center; color: white; font-size: 3rem;">
                            <i class="fas fa-<?= $item['jenis'] === 'foto' ? 'image' : 'video' ?>"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="gallery-caption">
                    <h4 class="gallery-title"><?= esc($item['nama_aktivitas']) ?></h4>
                    <?php if (!empty($item['tanggal']) || !empty($item['jam'])): ?>
                    <p class="gallery-meta">
                        <?php if (!empty($item['tanggal'])): ?>
                        <span><i class="fas fa-calendar"></i> <?= date('d F Y', strtotime($item['tanggal'])) ?></span>
                        <?php endif; ?>
                        <?php if (!empty($item['jam'])): ?>
                        <span><i class="fas fa-clock"></i> <?= date('H:i', strtotime($item['jam'])) ?></span>
                        <?php endif; ?>
                    </p>
                    <?php endif; ?>
                    <?php if (!empty($item['deskripsi'])): ?>
                    <p class="gallery-desc"><?= esc($item['deskripsi']) ?></p>
                    <?php endif; ?>
                </div>
            </a>
            <?php endforeach; ?>
        </div>
        <?php if (isset($pager)): ?>
        <div class="pagination" style="margin-top: 1.5rem;">
            <?= $pager->links('aktivitas_front', 'default_full') ?>
        </div>
        <?php endif; ?>
        <?php else: ?>
        <div class="empty-state">
            <p>Data aktivitas belum tersedia.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>

