<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class DemoData extends Seeder
{
    public function run()
    {
        // Biodata
        $biodata = [
            'nama' => 'John Doe',
            'alamat' => 'Jl. Contoh No. 123, Jakarta',
            'email' => 'john@example.com',
            'telepon' => '081234567890',
            'tentang' => 'Seorang profesional dengan pengalaman 5 tahun di bidang pengembangan web.',
            'keahlian' => 'PHP, CodeIgniter, JavaScript, MySQL, React',
            'pengalaman' => 'Full Stack Developer di Tech Company (2020-Sekarang)'
        ];
        $this->db->table('biodata')->insert($biodata);

        // Pendidikan
        $pendidikan = [
            [
                'jenjang' => 'SD',
                'institusi' => 'SD Negeri 1 Jakarta',
                'jurusan' => '-',
                'tahun_mulai' => '2005',
                'tahun_selesai' => '2011',
                'deskripsi' => null
            ],
            [
                'jenjang' => 'SMP',
                'institusi' => 'SMP Negeri 3 Jakarta',
                'jurusan' => '-',
                'tahun_mulai' => '2011',
                'tahun_selesai' => '2014',
                'deskripsi' => null
            ],
            [
                'jenjang' => 'SMA',
                'institusi' => 'SMA Negeri 1 Jakarta',
                'jurusan' => 'IPA',
                'tahun_mulai' => '2014',
                'tahun_selesai' => '2017',
                'deskripsi' => null
            ],
            [
                'jenjang' => 'S1',
                'institusi' => 'Universitas Yudharta Pasuruan',
                'jurusan' => 'Teknik Informatika',
                'tahun_mulai' => '2017',
                'tahun_selesai' => '2021',
                'deskripsi' => 'Lulus dengan predikat Cum Laude'
            ]
        ];
        $this->db->table('pendidikan')->insertBatch($pendidikan);

        // Aktivitas
        $aktivitas = [
            [
                'tanggal' => '2024-01-15',
                'jam' => '09:00:00',
                'nama_aktivitas' => 'Presentasi Proyek',
                'deskripsi' => 'Presentasi proyek akhir semester',
                'jenis' => 'foto',
                'file_path' => 'presentasi.jpg'
            ],
            [
                'tanggal' => '2024-01-16',
                'jam' => '14:00:00',
                'nama_aktivitas' => 'Workshop CodeIgniter',
                'deskripsi' => 'Workshop pengembangan web dengan CI4',
                'jenis' => 'video',
                'file_path' => 'workshop.mp4'
            ]
        ];
        $this->db->table('aktivitas')->insertBatch($aktivitas);
    }
}

