<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<section style="padding-top: 100px; padding-bottom: 60px;">
    <div class="container" style="max-width: 1200px;">
        <h2 class="section-title" style="text-align: left; margin-left: 0;">Curriculum Vitae</h2>

        <?php if ($biodata): ?>
        <?php
            $initial = '';
            if (!empty($biodata['nama'])) {
                $initial = mb_strtoupper(mb_substr($biodata['nama'], 0, 1, 'UTF-8'), 'UTF-8');
            }
            $skills = [];
            if (!empty($biodata['keahlian'])) {
                $skills = array_filter(array_map('trim', preg_split('/[,\\n]+/', $biodata['keahlian'])));
            }
        ?>

        <style>
            .cv-wrapper {
                display: grid;
                grid-template-columns: 280px 1fr;
                gap: 1.25rem;
                align-items: flex-start;
            }
            @media (max-width: 900px) {
                .cv-wrapper {
                    grid-template-columns: 1fr;
                }
            }
            .cv-sidebar {
                background: #0f172a;
                border-radius: 18px;
                padding: 2rem 1.6rem;
                box-shadow: 0 24px 60px rgba(15,23,42,0.95);
                display: flex;
                flex-direction: column;
                gap: 1.5rem;
            }
            .cv-photo {
                display: flex;
                justify-content: center;
                margin-bottom: 0.75rem;
            }
            .cv-photo-inner {
                width: 160px;
                height: 160px;
                border-radius: 50%;
                overflow: hidden;
                border: 4px solid var(--primary-color);
                box-shadow: 0 20px 55px rgba(15,23,42,0.95);
                background: linear-gradient(135deg, #1d4ed8, #0f766e);
                display: flex;
                align-items: center;
                justify-content: center;
                color: #eef2ff;
                font-weight: 600;
                font-size: 3rem;
            }
            .cv-sidebar h3 {
                font-size: 1rem;
                letter-spacing: 0.12em;
                text-transform: uppercase;
                color: #e5e7eb;
                margin-bottom: 0.5rem;
            }
            .cv-sidebar p {
                font-size: 0.9rem;
                color: #cbd5f5;
            }
            .cv-sidebar small {
                font-size: 0.8rem;
                color: #9ca3af;
            }
            .cv-main {
                background: radial-gradient(circle at top left, rgba(30,64,175,0.85), rgba(15,23,42,0.98));
                color: #e5e7eb;
                border-radius: 18px;
                padding: 0.6rem 1.4rem;
                box-shadow: 0 24px 60px rgba(15,23,42,0.9);
                border: 1px solid rgba(148,163,184,0.6);
                line-height: 1.4;
            }
            .cv-main-header {
                display: flex;
                flex-direction: column;
                gap: 0.08rem;
                border-bottom: 1px solid #e5e7eb;
                padding-bottom: 0.2rem;
                margin-bottom: 0.25rem;
            }
            .cv-main-header h1 {
                font-size: 2rem;
                letter-spacing: 0.08em;
                text-transform: uppercase;
            }
            .cv-main-header .cv-role {
                font-size: 0.95rem;
                text-transform: uppercase;
                letter-spacing: 0.18em;
                color: #cbd5f5;
            }
            .cv-main p {
                margin: 0.08rem 0;
            }
            .cv-main-contact {
                display: flex;
                flex-wrap: wrap;
                gap: 0.85rem;
                font-size: 0.9rem;
                color: #e5e7eb;
            }
            .cv-section-title {
                font-size: 0.9rem;
                text-transform: uppercase;
                letter-spacing: 0.14em;
                color: #c7d2fe;
                margin-bottom: 0.15rem;
                text-shadow: 0 0 10px rgba(59,130,246,0.35);
            }
            .cv-section {
                margin-top: 0.25rem;
                margin-bottom: 0.35rem;
            }
            .cv-section p {
                font-size: 0.92rem;
                color: #e5e7eb;
            }
            .cv-skills-list {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
                gap: 0.75rem 1.5rem;
            }
            .cv-skill-item {
                font-size: 0.9rem;
                color: #e5e7eb;
                display: flex;
                flex-direction: column;
                gap: 0.25rem;
            }
            .cv-skill-bar {
                height: 4px;
                border-radius: 999px;
                background: #e5e7eb;
                overflow: hidden;
            }
            .cv-skill-bar span {
                display: block;
                height: 100%;
                width: 80%;
                background: var(--gradient);
            }
            .cv-edu-item {
                display: grid;
                grid-template-columns: 1.4fr 2.2fr;
                gap: 0.8rem;
                font-size: 0.9rem;
                margin-bottom: 0.45rem;
            }
            .cv-edu-meta {
                color: #cbd5f5;
            }
            .cv-edu-title {
                font-weight: 600;
                margin-bottom: 0.15rem;
            }
        </style>

        <div class="cv-wrapper">
            <aside class="cv-sidebar">
                <div class="cv-photo">
                    <div class="cv-photo-inner">
                        <?php if (!empty($biodata['foto'])): ?>
                            <img src="<?= base_url(esc($biodata['foto'])) ?>" alt="Foto Profil <?= esc($biodata['nama']) ?>" style="width: 100%; height: 100%; object-fit: cover;">
                        <?php elseif ($initial !== ''): ?>
                            <span><?= esc($initial) ?></span>
                        <?php else: ?>
                            <span>?</span>
                        <?php endif; ?>
                    </div>
                </div>

                <div>
                    <h3>Tentang Saya</h3>
                    <p>
                        <?php if (!empty($biodata['tentang'])): ?>
                            <?= nl2br(esc($biodata['tentang'])) ?>
                        <?php else: ?>
                            Ringkasan singkat tentang diri Anda sebagai profesional yang terus belajar dan berkembang.
                        <?php endif; ?>
                    </p>
                </div>

                <div>
                    <h3>Kontak</h3>
                    <p><strong>Email</strong><br><?= esc($biodata['email']) ?></p>
                    <?php if (!empty($biodata['telepon'])): ?>
                    <p style="margin-top: 0.5rem;"><strong>Telepon</strong><br><?= esc($biodata['telepon']) ?></p>
                    <?php endif; ?>
                    <?php if (!empty($biodata['alamat'])): ?>
                    <p style="margin-top: 0.5rem;"><strong>Alamat</strong><br><?= esc($biodata['alamat']) ?></p>
                    <?php endif; ?>
                </div>

                <div>
                    <h3>Situs &amp; Sosial</h3>
                    <p>
                        <small>GitHub</small><br>
                        <a href="https://github.com" target="_blank" rel="noopener" style="color:#93c5fd; text-decoration:none;">github.com</a>
                    </p>
                    <p style="margin-top: 0.5rem;">
                        <small>Instagram</small><br>
                        <a href="https://instagram.com" target="_blank" rel="noopener" style="color:#fb7185; text-decoration:none;">instagram.com</a>
                    </p>
                </div>
            </aside>

            <main class="cv-main">
                <header class="cv-main-header">
                    <h1><?= esc($biodata['nama']) ?></h1>
                    <p class="cv-role">Pengembang Web</p>
                    <div class="cv-main-contact">
                        <span><i class="fas fa-envelope"></i> <?= esc($biodata['email']) ?></span>
                        <?php if (!empty($biodata['telepon'])): ?>
                        <span><i class="fas fa-phone"></i> <?= esc($biodata['telepon']) ?></span>
                        <?php endif; ?>
                    </div>
                </header>

                <?php if (!empty($biodata['pengalaman'])): ?>
                <section class="cv-section" id="pengalaman">
                    <div class="cv-section-title">Pengalaman Kerja</div>
                    <p><?= nl2br(esc($biodata['pengalaman'])) ?></p>
                </section>
                <?php endif; ?>

                <?php if (!empty($pendidikan)): ?>
                <section class="cv-section">
                    <div class="cv-section-title">Pendidikan</div>
                    <?php foreach ($pendidikan as $edu): ?>
                        <div class="cv-edu-item">
                            <div>
                                <div class="cv-edu-title"><?= esc($edu['institusi']) ?></div>
                                <div class="cv-edu-meta"><?= esc($edu['jenjang']) ?><?= !empty($edu['jurusan']) && $edu['jurusan'] !== '-' ? ' - ' . esc($edu['jurusan']) : '' ?></div>
                                <div class="cv-edu-meta"><?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?></div>
                            </div>
                            <div>
                                <?php if (!empty($edu['deskripsi'])): ?>
                                    <p><?= nl2br(esc($edu['deskripsi'])) ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </section>
                <?php endif; ?>

                <?php if (!empty($skills)): ?>
                <section class="cv-section">
                    <div class="cv-section-title">Keahlian</div>
                    <div class="cv-skills-list">
                        <?php foreach ($skills as $skill): ?>
                        <div class="cv-skill-item">
                            <span><?= esc($skill) ?></span>
                            <div class="cv-skill-bar"><span></span></div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </section>
                <?php endif; ?>
            </main>
        </div>

        <?php else: ?>
        <div class="empty-state">
            <p>Data biodata belum tersedia.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>

