<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Produk;
use App\Models\Transaksi;

class DashboardController extends Controller
{
    public function index()
    {
        $produks = Produk::all();
        $totalProduk = Produk::count();
        $totalStok = Produk::sum('stok');
        $transaksiHariIni = Transaksi::whereDate('created_at', today())->count();
        $produkStokMenipis = Produk::where('stok', '<=', 5)->count();
        
        return view('dashboard', compact('produks', 'totalProduk', 'totalStok', 'transaksiHariIni', 'produkStokMenipis'));
    }
}
