<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;

class InspectDb extends BaseCommand
{
    protected $group = 'Database';
    protected $name = 'db:inspect';
    protected $description = 'Inspects the biodata table columns.';

    public function run(array $params)
    {
        $db = \Config\Database::connect();

        try {
            $query = $db->query('DESCRIBE biodata');
            $results = $query->getResultArray();

            CLI::write("Table: biodata", 'green');
            foreach ($results as $row) {
                CLI::write("Field: " . $row['Field'] . " | Type: " . $row['Type']);
            }
        } catch (\Exception $e) {
            CLI::error($e->getMessage());
        }
    }
}
