<?php
namespace App\Controllers;

use CodeIgniter\Controller;

class AdminController extends Controller
{
    // Fungsi untuk menampilkan halaman login
    public function login()
    {
        // Jika admin sudah login, redirect ke dashboard
        if (session()->get('isLoggedIn')) {
            return redirect()->to(base_url('admin/dashboard'));
        }
        return view('admin_login');
    }

    // Fungsi untuk memproses form login
    public function auth()
    {
        $session = session();
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        // --- Logika Verifikasi (Contoh Sederhana) ---
        // GANTI DENGAN LOGIKA OTENTIKASI DATABASE/MODEL SESUNGGUHNYA
        $validUsername = 'adminmyci';
        $validPassword = 'password123';

        if ($username == $validUsername && $password == $validPassword) {
            // Berhasil login
            $session->set([
                'isLoggedIn' => true,
                'username' => $username,
                // Tambahkan data user lain dari DB di sini
            ]);
            return redirect()->to(base_url('admin/dashboard'));
        } else {
            // Gagal login
            $session->setFlashdata('error', 'Username atau Password salah.');
            return redirect()->back()->withInput();
        }
    }

    // Fungsi Logout
    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('admin/login'));
    }

    // Dashboard Default
    public function index()
    {
        $activityModel = new \App\Models\ActivityModel();
        $educationModel = new \App\Models\EducationModel();

        $data = [
            'title' => 'Dashboard Overview',
            'count_activities' => $activityModel->countAll(),
            'count_education' => $educationModel->countAll(),
        ];

        return view('admin/dashboard', $data);
    }
}