<?php

namespace App\Models;

use CodeIgniter\Model;

class PegawaiModel extends Model
{
    protected $table            = 'pegawai';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;

    protected $allowedFields = [
        'nama_pegawai',
        'tanggal_lahir',
        'jenis_kelamin',
        'foto_pegawai',
        'slug',
        'status'
    ];

    // TIMESTAMPS DIMATIKAN → HAPUS BARIS INI!
    protected $useTimestamps = false;
    // HAPUS 3 BARIS DI BAWAH INI:
    // protected $dateFormat    = 'datetime';
    // protected $createdField  = 'created_at';
    // protected $updatedField  = 'updated_at';

    // Fungsi ambil data berdasarkan slug atau ID
    public function getPegawai($slug = false)
    {
        if ($slug === false) {
            return $this->findAll();
        }

        return $this->where('slug', $slug)
                    ->orWhere('id', $slug)
                    ->first();
    }
}