<?php
// Definisikan variabel warna baru sesuai palet yang diberikan
$color_d = '#645c55';   // Headline (Dark Brown - Judul & Teks Utama)
$color_h = '#faae2b';   // Button/Highlight (Kuning Oranye - Aksen Kuat)
$color_c = '#e3ddd5';   // Secondary (Beige - Aksen Lembut)

// Warna tambahan dari palet
$color_bg = '#f2f7f5';  // Background
$color_text = '#475d5b'; // Paragraph Text
$color_stroke = '#00332c'; // Stroke/Garis
?>

<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
    /* Styling Baru: Arch Design & Earthy Tones */
    body {
        background-color:
            <?php echo $color_bg; ?>
        ;
        /* Light Greenish/Grey */
    }

    /* Animations */
    @keyframes slideUpFade {
        from {
            transform: translateY(40px);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    @keyframes pulseSoft {
        0% {
            box-shadow: 0 0 0 0 rgba(250, 174, 43, 0.4);
        }

        70% {
            box-shadow: 0 0 0 10px rgba(250, 174, 43, 0);
        }

        100% {
            box-shadow: 0 0 0 0 rgba(250, 174, 43, 0);
        }
    }

    /* Arch Hero Section */
    .biodata-hero {
        background: linear-gradient(135deg,
                <?php echo $color_c; ?>
                0%, #e8e0d5 100%);
        padding: 80px 0 120px 0;
        text-align: center;
        border-bottom-left-radius: 50% 30px;
        border-bottom-right-radius: 50% 30px;
        position: relative;
        overflow: hidden;
    }

    .biodata-hero::before {
        content: '';
        position: absolute;
        top: -50px;
        left: -50px;
        width: 200px;
        height: 200px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 50%;
        filter: blur(40px);
    }

    .biodata-hero h1 {
        font-family: 'Playfair Display', serif;
        font-weight: 700;
        font-size: 3rem;
        color:
            <?php echo $color_d; ?>
        ;
        margin-bottom: 10px;
        letter-spacing: 1px;
        position: relative;
        z-index: 2;
    }

    .biodata-hero p {
        font-size: 1.1rem;
        color:
            <?php echo $color_text; ?>
        ;
        font-family: 'Montserrat', sans-serif;
        font-weight: 500;
        position: relative;
        z-index: 2;
        letter-spacing: 2px;
        text-transform: uppercase;
        font-size: 0.8rem;
    }

    /* Floating Card with Arch Element */
    .biodata-container {
        margin-top: -80px;
        /* Overlap with hero */
        padding-bottom: 80px;
    }

    .biodata-card-arch {
        background: #ffffff;
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(100, 92, 85, 0.08);
        padding: 70px 40px 40px 40px;
        position: relative;
        border: 1px solid rgba(255, 255, 255, 0.8);
        max-width: 550px;
        margin: 0 auto;
        text-align: center;
        animation: slideUpFade 0.8s cubic-bezier(0.2, 0.8, 0.2, 1) forwards;
    }

    .card-top-icon {
        width: 100px;
        height: 100px;
        background-color:
            <?php echo $color_d; ?>
        ;
        color:
            <?php echo $color_c; ?>
        ;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 3rem;
        margin: -90px auto 30px auto;
        /* Pull up less high */
        border: 6px solid #fff;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        position: relative;
        z-index: 10;
        /* Optional: Add image here if user has one using background-image */
    }

    .data-group {
        text-align: left;
        margin-top: 20px;
    }

    .data-item {
        margin-bottom: 15px;
        background: #fafafa;
        border-radius: 12px;
        padding: 15px 20px;
        display: flex;
        align-items: center;
        gap: 20px;
        transition: all 0.3s ease;
        border-left: 4px solid transparent;
    }

    .data-item:hover {
        background: #fff;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        transform: translateY(-2px);
        border-left: 4px solid
            <?php echo $color_h; ?>
        ;
    }

    .icon-box {
        width: 40px;
        height: 40px;
        background:
            <?php echo $color_c; ?>
        ;
        color:
            <?php echo $color_d; ?>
        ;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
        flex-shrink: 0;
    }

    .text-box {
        display: flex;
        flex-direction: column;
        width: 100%;
    }

    .label-arch {
        font-family: 'Montserrat', sans-serif;
        font-weight: 600;
        color:
            <?php echo $color_d; ?>
        ;
        font-size: 0.75rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        opacity: 0.7;
        margin-bottom: 2px;
    }

    .value-arch {
        font-family: 'Montserrat', sans-serif;
        font-weight: 500;
        color:
            <?php echo $color_text; ?>
        ;
        font-size: 1rem;
        word-break: break-word;
    }

    .card-footer-decor {
        margin-top: 30px;
        opacity: 0.5;
        font-size: 1.5rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .biodata-hero {
            padding: 60px 0 100px 0;
        }

        .biodata-card-arch {
            margin: 0 20px;
            padding: 60px 20px 30px 20px;
        }

        .data-item {
            padding: 12px 15px;
            gap: 15px;
        }

        .value-arch {
            font-size: 0.95rem;
        }
    }
</style>

<!-- Top Hero -->
<div class="biodata-hero">
    <div class="container">
        <h1>Biodata Diri</h1>
        <p>Personal & Professional Details</p>
    </div>
</div>

<!-- Search & Filter Section -->
<div class="container" style="margin-top: -30px; position: relative; z-index: 10; margin-bottom: 80px;">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="p-3 bg-white shadow-sm" style="border-radius: 15px; border: 1px solid rgba(0,0,0,0.05);">
                <form action="" method="get">
                    <div class="row align-items-center g-2">

                        <!-- Search Input -->
                        <div class="col-md-5 mb-2 mb-md-0">
                            <input type="text" name="q" value="<?= esc($search) ?>"
                                class="form-control border-0 shadow-none" placeholder="Cari nama, alamat..."
                                style="background: #f8f9fa; border-radius: 8px; font-size: 0.9rem; padding: 8px 12px;">
                        </div>

                        <!-- Religion Filter -->
                        <div class="col-md-3 mb-2 mb-md-0">
                            <select name="religion_filter" class="form-control border-0 shadow-none form-select"
                                style="background: #f8f9fa; border-radius: 8px; font-size: 0.9rem; padding: 8px 12px; height: auto;">
                                <option value="Semua Agama" <?= ($religion_filter == 'Semua Agama' || !$religion_filter) ? 'selected' : '' ?>>Semua Agama</option>
                                <option value="Islam" <?= ($religion_filter == 'Islam') ? 'selected' : '' ?>>Islam</option>
                                <option value="Kristen" <?= ($religion_filter == 'Kristen') ? 'selected' : '' ?>>Kristen
                                </option>
                                <option value="Katolik" <?= ($religion_filter == 'Katolik') ? 'selected' : '' ?>>Katolik
                                </option>
                                <option value="Hindu" <?= ($religion_filter == 'Hindu') ? 'selected' : '' ?>>Hindu</option>
                                <option value="Buddha" <?= ($religion_filter == 'Buddha') ? 'selected' : '' ?>>Buddha
                                </option>
                            </select>
                        </div>

                        <!-- Buttons -->
                        <div class="col-md-4 d-flex gap-2">
                            <button type="submit" class="btn w-100 font-weight-bold text-white btn-theme-main"
                                style="background-color: <?= $color_d ?>; border-radius: 8px; font-size: 0.9rem; padding: 6px 10px; box-shadow: 0 2px 5px rgba(100, 92, 85, 0.2);">
                                Cari
                            </button>
                            <a href="?" class="btn w-100 font-weight-bold text-white btn-theme-accent"
                                style="background-color: <?= $color_h ?>; border-radius: 8px; font-size: 0.9rem; padding: 6px 10px; box-shadow: 0 2px 5px rgba(250, 174, 43, 0.2);">
                                Reset
                            </a>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    /* Hover effects for buttons */
    .btn-theme-main:hover {
        background-color: #4e4640 !important;
        /* Slightly darker brown */
        transform: translateY(-2px);
    }

    .btn-theme-accent:hover {
        background-color: #e59a1f !important;
        /* Slightly darker orange */
        transform: translateY(-2px);
    }
</style>

<!-- Main Content -->
<div class="biodata-container" style="margin-top: 0;"> <!-- Reset margin top here as we have the filter bar now -->
    <div class="container">

        <?php if (empty($biodata)): ?>
            <div class="text-center py-5">
                <i class="fas fa-search mb-3" style="font-size: 3rem; color: #ddd;"></i>
                <p style="color: <?= $color_text ?>; font-family: 'Montserrat', sans-serif;">Biodata tidak ditemukan.</p>
            </div>
        <?php else: ?>

            <?php foreach ($biodata as $bio): ?>
                <div class="biodata-card-arch mb-5">
                    <!-- Icon/Photo Placeholder at top of Arc -->
                    <div class="card-top-icon"
                        style="<?= !empty($bio['photo']) ? 'padding: 0; overflow: hidden; border: 6px solid #fff;' : '' ?>">
                        <?php if (!empty($bio['photo'])): ?>
                            <img src="<?= base_url('uploads/biodata/' . $bio['photo']) ?>" alt="Profile"
                                style="width: 100%; height: 100%; object-fit: cover;">
                        <?php else: ?>
                            <i class="fas fa-user-circle"></i>
                        <?php endif; ?>
                    </div>

                    <div class="data-group">
                        <div class="data-item">
                            <div class="icon-box"><i class="fas fa-id-card"></i></div>
                            <div class="text-box">
                                <span class="label-arch">Nama Lengkap</span>
                                <span class="value-arch"><?= esc($bio['name']) ?></span>
                            </div>
                        </div>

                        <div class="data-item">
                            <div class="icon-box"><i class="fas fa-briefcase"></i></div>
                            <div class="text-box">
                                <span class="label-arch">Profesi / Job Title</span>
                                <span class="value-arch"><?= !empty($bio['job_title']) ? esc($bio['job_title']) : '-' ?></span>
                            </div>
                        </div>

                        <div class="data-item">
                            <div class="icon-box"><i class="fas fa-map-marker-alt"></i></div>
                            <div class="text-box">
                                <span class="label-arch">Alamat</span>
                                <span class="value-arch"><?= !empty($bio['address']) ? esc($bio['address']) : '-' ?></span>
                            </div>
                        </div>

                        <div class="data-item">
                            <div class="icon-box"><i class="fas fa-phone-alt"></i></div>
                            <div class="text-box">
                                <span class="label-arch">No. Handphone</span>
                                <span class="value-arch"><?= !empty($bio['phone']) ? esc($bio['phone']) : '-' ?></span>
                            </div>
                        </div>

                        <div class="data-item">
                            <div class="icon-box"><i class="fas fa-envelope"></i></div>
                            <div class="text-box">
                                <span class="label-arch">Alamat Email</span>
                                <span class="value-arch"><?= !empty($bio['email']) ? esc($bio['email']) : '-' ?></span>
                            </div>
                        </div>

                        <div class="data-item">
                            <div class="icon-box"><i class="fas fa-align-left"></i></div>
                            <div class="text-box">
                                <span class="label-arch">Ringkasan Diri</span>
                                <span
                                    class="value-arch"><?= !empty($bio['summary']) ? nl2br(esc($bio['summary'])) : '-' ?></span>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endforeach; ?>

        <?php endif; ?>

        <!-- Pagination Links -->
        <?php if ($totalPages >= 1): ?>
            <div class="mt-5 d-flex justify-content-center">
                <nav aria-label="Page navigation">
                    <ul class="pagination">
                        <!-- Prev -->
                        <?php if ($totalPages > 1): ?>
                            <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                                <a class="page-link"
                                    href="?q=<?= esc($search) ?>&religion_filter=<?= esc($religion_filter) ?>&page=<?= $page - 1 ?>"
                                    aria-label="Previous">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <!-- Page Numbers -->
                        <?php for ($p = 1; $p <= $totalPages; $p++): ?>
                            <li class="page-item <?= ($page == $p) ? 'active' : '' ?>">
                                <a class="page-link"
                                    style="<?= ($page == $p) ? 'background-color: ' . $color_h . '; border-color: ' . $color_h . '; color: #fff;' : 'color: ' . $color_d . ';' ?>"
                                    href="?q=<?= esc($search) ?>&religion_filter=<?= esc($religion_filter) ?>&page=<?= $p ?>"><?= $p ?></a>
                            </li>
                        <?php endfor; ?>

                        <!-- Next -->
                        <?php if ($totalPages > 1): ?>
                            <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                                <a class="page-link"
                                    href="?q=<?= esc($search) ?>&religion_filter=<?= esc($religion_filter) ?>&page=<?= $page + 1 ?>"
                                    aria-label="Next">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        <?php endif; ?>

    </div>
</div>

<?= $this->endSection() ?>