<?php
// Definisikan variabel warna BARU
$color_d = '#00473e';   // Warna Utama Admin (Headline - Judul, Label, Teks Kuat)
$color_h = '#faae2b';   // Aksi Utama (Highlight - Publish Button, Garis Aksen)
$color_c = '#ffa8ba';   // Aksen Lembut/Focus (Secondary - Border Input Focus)

// Tentukan apakah ini mode Edit atau Tambah Baru
$is_edit = isset($pegawai['id']) && $pegawai['id'] > 0;
// Menggunakan variabel $pegawai dan helper old() untuk mempertahankan input
$form_title = $is_edit 
    ? 'Edit Data Pegawai: ' . (old('nama_pegawai', $pegawai['nama_pegawai'] ?? '')) 
    : 'Tambah Pegawai Baru';

// Hitung warna hover baru untuk Button Publish
$color_h_hover = '#d49525'; // Kuning Oranye sedikit lebih gelap
?>

<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<style>
    /* --------------------- STYLING KUSTOM FORM ADMIN --------------------- */
    
    /* Warna Judul Halaman */
    .admin-title {
        color: <?php echo $color_d; ?>; /* Hijau Tua */
        font-weight: 700;
        margin-bottom: 30px;
        border-bottom: 3px solid <?php echo $color_h; ?>; /* Garis bawah Warna H (Kuning Oranye) */
        padding-bottom: 10px;
    }
    
    /* Icon di Judul */
    .admin-title .fas {
        color: <?php echo $color_h; ?>;
    }

    /* Label Form */
    .form-group label {
        color: <?php echo $color_d; ?>; /* Hijau Tua */
        font-weight: 600;
        margin-bottom: 8px;
    }

    /* Input dan Textarea Focus Effect */
    .form-control:focus {
        border-color: <?php echo $color_c; ?>; /* Border fokus menggunakan Warna C (Pink Muda) */
        /* Bayangan Warna C transparan 25% */
        box-shadow: 0 0 0 0.2rem rgba(255, 168, 186, 0.25); 
    }

    /* Tombol Utama (Publish) */
    .btn-publish {
        background-color: <?php echo $color_h; ?>; /* Warna H (Kuning Oranye) */
        border-color: <?php echo $color_h; ?>;
        color: <?php echo $color_d; ?>; /* Teks menggunakan D agar kontras */
        font-weight: bold;
        transition: background-color 0.3s;
    }
    .btn-publish:hover {
        background-color: <?php echo $color_h_hover; ?>; /* H sedikit lebih gelap */
        border-color: <?php echo $color_h_hover; ?>;
        color: <?php echo $color_d; ?>;
    }

    /* Tombol Sekunder (Save Draft) */
    .btn-draft {
        background-color: #a8a8a8; /* Abu-abu netral */
        border-color: #a8a8a8;
        color: white;
        font-weight: 600;
        transition: background-color 0.3s;
    }
    .btn-draft:hover {
        background-color: #8f8f8f;
        border-color: #8f8f8f;
    }
    /* Preview Foto */
    .photo-preview {
        max-width: 150px;
        height: auto;
        border: 1px solid #ddd;
        padding: 5px;
        margin-top: 10px;
    }
</style>

<div class="container-fluid py-4">
    <h2 class="admin-title">
        <i class="fas fa-edit"></i> <?= $form_title ?>
    </h2>

    <form action="<?= base_url('admin/pegawai/save') ?>" method="post" id="text-editor" enctype="multipart/form-data">
        
        <?= csrf_field() ?>
        
                <input type="hidden" name="id" value="<?= old('id', $pegawai['id'] ?? '') ?>" />
        
        <input type="hidden" name="slug" value="<?= old('slug', $pegawai['slug'] ?? '') ?>" />

                <div class="form-group mb-3">
            <label for="nama_pegawai">Nama Pegawai</label>
            <input type="text" name="nama_pegawai" class="form-control" 
                placeholder="Nama Lengkap Pegawai" 
                value="<?= old('nama_pegawai', $pegawai['nama_pegawai'] ?? '') ?>" required>
            <?php if (session('errors.nama_pegawai')) : ?>
                <small class="text-danger"><?= session('errors.nama_pegawai') ?></small>
            <?php endif ?>
        </div>

        <div class="row">
            <div class="col-md-6 form-group mb-3">
                <label for="tanggal_lahir">Tanggal Lahir</label>
                <input type="date" name="tanggal_lahir" class="form-control" 
                    value="<?= old('tanggal_lahir', $pegawai['tanggal_lahir'] ?? '') ?>" required>
            </div>
            
            <div class="col-md-6 form-group mb-3">
                <label for="jenis_kelamin">Jenis Kelamin</label>
                <select name="jenis_kelamin" class="form-control" required>
                    <?php $jk = old('jenis_kelamin', $pegawai['jenis_kelamin'] ?? ''); ?>
                    <option value="">-- Pilih --</option>
                    <option value="Laki-laki" <?= ($jk == 'Laki-laki') ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= ($jk == 'Perempuan') ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
        </div>

        <div class="form-group mb-3">
            <label for="foto_pegawai">Foto Pegawai</label>
            <input type="file" name="foto_pegawai" class="form-control">
            <?php if ($is_edit && !empty($pegawai['foto_pegawai'])): ?>
                <p class="mt-2">Foto saat ini:</p>
                <img src="/img/pegawai/<?= $pegawai['foto_pegawai'] ?>" alt="Foto Pegawai Saat Ini" class="photo-preview img-fluid rounded">
                <input type="hidden" name="old_foto_pegawai" value="<?= $pegawai['foto_pegawai'] ?>">
            <?php endif; ?>
        </div>

        <div class="form-group mb-3">
            <label for="author">Author (Opsional)</label>
            <input type="text" name="author" class="form-control" 
                value="<?= old('author', $pegawai['author'] ?? '') ?>">
        </div>

                <div class="form-group mb-4">
            <label for="content">Keterangan / Isi Konten</label>
            <textarea name="content" 
                class="form-control" 
                rows="15" 
                placeholder="Mulai menulis konten yang menarik..."
            ><?= old('content', $pegawai['content'] ?? '') ?></textarea>
        </div>
        
                <div class="form-group">
            <button type="submit" name="status" value="published" class="btn btn-publish">
                <i class="fas fa-check-circle"></i> Publikasikan Sekarang
            </button>
            <button type="submit" name="status" value="draft" class="btn btn-draft">
                <i class="fas fa-save"></i> Simpan ke Draft
            </button>
        </div>
    </form>
</div>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<?= $this->endSection() ?>
