<?php
// MAPPING WARNA BARU BERDASARKAN PALET GAMBAR:
$color_d = '#00473e';  // Hijau Tua (Headline, Table Header BG, Button Text, Outline Button Border)
$color_h = '#faae2b';  // Oranye (Button BG, Highlight, Admin Title Border)
$color_c = '#ffa8ba';  // Pink (Secondary, Employee Photo Border, Danger Outline Button Hover)
$color_text_muted = '#475d5b'; // Abu-abu Tua (Paragraph/Muted Text)

// Warna latar belakang dari palet:
$color_background = '#f2f7f5'; 
// Warna danger dari palet (Tertiary):
$color_danger = '#fa5246'; 
?>

<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<style>
/* Judul */
.admin-title {
    color: <?= $color_d ?>;
    font-weight: 700;
    border-bottom: 3px solid <?= $color_h ?>; /* Oranye/Highlight */
    padding-bottom: 10px;
}

/* Header tabel */
.table thead th {
    background-color: <?= $color_d ?>; /* Hijau Tua/Headline */
    color: white;
    border-color: <?= $color_c ?>; /* Pink/Secondary */
    font-weight: 600;
}

/* Hover row */
.table tbody tr:hover {
    background-color: <?= $color_background ?>; /* Background/Main */
}

/* Tengah alignment */
.table td {
    vertical-align: middle;
}

/* Foto bulat */
.employee-photo {
    width: 45px;
    height: 45px;
    object-fit: cover;
    border-radius: 50%;
    border: 2px solid <?= $color_c ?>; /* Pink/Secondary */
}

/* Tombol utama (primary/tambah) */
.btn-primary-custom {
    background-color: <?= $color_h ?> !important; /* Oranye/Highlight */
    border-color: <?= $color_h ?> !important;
    color: <?= $color_d ?> !important; /* Hijau Tua/Headline */
    font-weight: 700;
}

.btn-primary-custom:hover {
    background-color: #d49525 !important; /* Darker Oranye */
}

/* Tombol warning (preview) */
.btn-warning-custom {
    background-color: <?= $color_h ?> !important; /* Oranye/Highlight */
    border-color: <?= $color_h ?> !important;
    color: <?= $color_d ?> !important; /* Hijau Tua/Headline */
    font-weight: 600;
}

.btn-warning-custom:hover {
    background-color: #d49525 !important; /* Darker Oranye */
    color: white !important;
}

/* Tombol Outline (Edit) */
.btn-outline-primary {
    color: <?= $color_d ?>;
    border-color: <?= $color_d ?>;
}
.btn-outline-primary:hover {
    background-color: <?= $color_d ?>;
    color: white;
}

/* Tombol Outline Danger (Delete) */
.btn-outline-danger {
    color: <?= $color_danger ?>; /* Merah/Tertiary */
    border-color: <?= $color_danger ?>;
}
.btn-outline-danger:hover {
    background-color: <?= $color_danger ?>;
    color: white;
}

/* Teks Muted */
.text-muted {
    color: <?= $color_text_muted ?> !important; /* Paragraph */
}
</style>

<div class="container py-3">
    <h3 class="admin-title">Kelola Daftar Pegawai</h3>

    <a href="<?= base_url('admin/pegawai/create') ?>"
       class="btn btn-primary-custom mb-3">
       + Tambah Pegawai Baru
    </a>

        <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="table-responsive shadow-sm">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nama Pegawai</th>
                    <th>Jenis Kelamin</th>
                    <th>Foto</th>
                    <th>Tanggal Lahir</th>
                    <th>Aksi</th>
                </tr>
            </thead>

            <tbody>
            <?php $no = 1; foreach($pegawai_list as $pg): ?>
                <?php $pg = (object)$pg; ?>

                <tr>
                    <td><?= $no++ ?></td>

                                        <td>
                        <strong><?= esc($pg->nama_pegawai) ?></strong><br>
                        <small class="text-muted">
                            Terdaftar: <?= date('d M Y H:i') ?>
                        </small>
                    </td>

                                        <td>
                        <?= ($pg->jenis_kelamin == 'laki-laki') ? 'Laki-laki' : 'Perempuan' ?>
                    </td>

                                        <td>
                        <?php if ($pg->foto_pegawai && $pg->foto_pegawai !== 'default.jpg'): ?>
                            <img src="<?= base_url('img/pegawai/' . $pg->foto_pegawai) ?>"
                                 class="employee-photo" alt="Foto <?= esc($pg->nama_pegawai) ?>">
                        <?php else: ?>
                            <small class="text-danger">Tidak Ada Foto</small>
                        <?php endif; ?>
                    </td>

                                        <td>
                        <?= $pg->tanggal_lahir ? date('d M Y', strtotime($pg->tanggal_lahir)) : '-' ?>
                    </td>

                                        <td>
                                                <a href="<?= base_url('news/detail/' . $pg->slug) ?>"
                           class="btn btn-sm btn-warning-custom"
                           target="_blank"
                           rel="noopener">
                           Preview
                        </a>

                                                <a href="<?= base_url('admin/pegawai/edit/' . $pg->slug) ?>"
                           class="btn btn-sm btn-outline-primary">
                           Edit
                        </a>

                                                <button class="btn btn-sm btn-outline-danger"
                                data-bs-toggle="modal"
                                data-bs-target="#confirm-dialog"
                                data-href="<?= base_url('admin/pegawai/delete/' . $pg->id) ?>">
                            Delete
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>

            <?php if (empty($pegawai_list)): ?>
                <tr>
                    <td colspan="6" class="text-center text-muted">Belum ada data pegawai.</td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="confirm-dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Yakin ingin menghapus pegawai ini? Tindakan ini tidak dapat dibatalkan.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <a id="delete-button" href="#" class="btn btn-danger">Hapus Permanen</a>
            </div>
        </div>
    </div>
</div>

<script>
    const modal = document.getElementById('confirm-dialog');
    modal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const href = button.getAttribute('data-href');
        document.getElementById('delete-button').setAttribute('href', href);
    });
</script>

<?= $this->endSection() ?>
