<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-lg-10">
        <div class="card border-0 shadow-sm" style="border-radius: 15px;">
            <div class="card-header bg-white border-bottom-0 py-3 d-flex justify-content-between align-items-center"
                style="border-radius: 15px 15px 0 0;">
                <h5 class="mb-0 fw-bold" style="color: var(--primary-color);">Profil Biodata</h5>
                <?php if (!$profile): ?>
                    <a href="<?= base_url('admin/biodata/create') ?>" class="btn btn-primary btn-sm text-white">
                        <i class="fas fa-plus me-1"></i> Buat Biodata
                    </a>
                <?php else: ?>
                    <a href="<?= base_url('admin/biodata/edit/' . $profile['id']) ?>"
                        class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-edit me-1"></i> Edit Profil
                    </a>
                    <a href="<?= base_url('admin/biodata/delete/' . $profile['id']) ?>"
                        class="btn btn-outline-danger btn-sm ms-2"
                        onclick="return confirm('Apakah Anda yakin ingin menghapus biodata ini?');">
                        <i class="fas fa-trash me-1"></i> Hapus
                    </a>
                <?php endif; ?>
            </div>
            <div class="card-body p-4">

                <?php if (!$profile): ?>
                    <div class="text-center py-5 text-muted">
                        <i class="fas fa-user-slash fa-3x mb-3" style="opacity: 0.3;"></i>
                        <p>Belum ada data biodata yang dibuat.</p>
                    </div>
                <?php else: ?>
                    <div class="row">
                        <div class="col-md-4 text-center mb-4 mb-md-0">
                            <?php if (!empty($profile['photo'])): ?>
                                <img src="<?= base_url('uploads/biodata/' . $profile['photo']) ?>" alt="Profile Photo"
                                    class="img-fluid rounded-circle shadow-sm mb-3"
                                    style="width: 200px; height: 200px; object-fit: cover;">
                            <?php else: ?>
                                <div class="rounded-circle bg-light d-flex align-items-center justify-content-center mx-auto mb-3"
                                    style="width: 200px; height: 200px;">
                                    <i class="fas fa-user fa-4x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            <h4 class="fw-bold text-dark mb-1"><?= !empty($profile['name']) ? esc($profile['name']) : '' ?>
                            </h4>
                            <p class="text-muted"><?= !empty($profile['job_title']) ? esc($profile['job_title']) : '' ?></p>
                        </div>
                        <div class="col-md-8">
                            <h6 class="text-uppercase text-muted small fw-bold mb-3">Informasi Kontak</h6>
                            <div class="row mb-4">
                                <div class="col-sm-4 fw-bold text-muted">Email</div>
                                <div class="col-sm-8 text-dark">
                                    <?= !empty($profile['email']) ? esc($profile['email']) : '' ?>
                                </div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-sm-4 fw-bold text-muted">Telepon</div>
                                <div class="col-sm-8 text-dark">
                                    <?= !empty($profile['phone']) ? esc($profile['phone']) : '' ?>
                                </div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-sm-4 fw-bold text-muted">Alamat</div>
                                <div class="col-sm-8 text-dark">
                                    <?= !empty($profile['address']) ? esc($profile['address']) : '' ?>
                                </div>
                            </div>

                            <h6 class="text-uppercase text-muted small fw-bold mb-3 mt-4">Ringkasan Profesional</h6>
                            <p class="text-dark bg-light p-3 rounded" style="font-size: 0.95rem; line-height: 1.6;">
                                <?= !empty($profile['summary']) ? nl2br(esc($profile['summary'])) : '' ?>
                            </p>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>