<?php
// Definisikan variabel warna baru sesuai palet yang diberikan
$color_d = '#00473e';   // Headline (Hijau Tua - Latar Belakang Info, Judul Form, Hover Tombol)
$color_h = '#faae2b';   // Button/Highlight (Kuning Oranye - Tombol Kirim, Ikon Info, Judul Info)
$color_c = '#ffa8ba';   // Secondary (Pink Muda - Aksen Fokus Form, Border Info, Metadata Info)

// Warna tambahan dari palet
$color_text = '#475d5b'; // Paragraph Text (Teks Pendamping Form)
?>

<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
    /* Styling Kustom untuk Halaman Kontak */
    .contact-container {
        padding: 50px 0;
    }
    .form-section h3 {
        /* Judul Formulir menggunakan Warna D (Hijau Tua) */
        color: <?php echo $color_d; ?>;
        font-weight: 700;
        margin-bottom: 5px;
    }
    .form-section p {
        /* Teks pendamping menggunakan warna Paragraph baru */
        color: <?php echo $color_text; ?>;
        margin-bottom: 30px;
    }
    .form-control:focus {
        /* Border fokus menggunakan Warna C (Pink Muda) */
        border-color: <?php echo $color_c; ?>; 
        /* Bayangan Warna C transparan */
        box-shadow: 0 0 0 0.2rem rgba(255, 168, 186, 0.4); 
    }
    .submit-btn {
        /* Tombol Kirim Warna H (Kuning Oranye) */
        background-color: <?php echo $color_h; ?>; 
        border-color: <?php echo $color_h; ?>;
        /* Teks tombol menggunakan warna D (Hijau Tua) agar kontras */
        color: <?php echo $color_d; ?>;
        font-weight: bold;
        transition: background-color 0.3s;
    }
    .submit-btn:hover {
        /* Hover menggunakan Warna D (Hijau Tua) */
        background-color: <?php echo $color_d; ?>; 
        border-color: <?php echo $color_d; ?>;
        color: white; /* Teks menjadi putih saat hover */
    }

    /* Styling Info Kontak (Sisi Kanan) */
    .info-section {
        /* Latar Belakang Warna D (Hijau Tua) */
        background-color: <?php echo $color_d; ?>; 
        color: white;
        padding: 30px;
        border-radius: 8px;
        height: 100%;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }
    .info-section h4 {
        /* Judul info Warna H (Kuning Oranye) */
        color: <?php echo $color_h; ?>; 
        font-weight: 600;
        margin-bottom: 20px;
        /* Garis Aksen menggunakan Warna C (Pink Muda) */
        border-bottom: 2px solid <?php echo $color_c; ?>;
        padding-bottom: 10px;
    }
    .contact-item {
        margin-bottom: 20px;
        display: flex;
        align-items: flex-start;
    }
    .contact-item i {
        /* Ikon Info Warna H (Kuning Oranye) */
        color: <?php echo $color_h; ?>; 
        font-size: 1.5rem;
        margin-right: 15px;
        margin-top: 3px;
    }
    .contact-item span {
        font-size: 0.95rem;
    }
</style>

<div class="container contact-container">
    <div class="row">
        
        <div class="col-md-6 form-section mb-4">

            <h3 class="h3">Halo Madani Yatsi Creativity</h3>
            <p>Silakan hubungi kami melalui formulir di bawah ini untuk pertanyaan, penawaran, atau kolaborasi.</p>

            <form action="" method="post">

                <div class="form-group mb-3">
                    <label for="name">Nama Lengkap</label>
                    <input type="text" name="name" class="form-control" placeholder="Masukkan Nama Anda">
                </div>
                
                <div class="form-group mb-3">
                    <label for="email">Email</label>
                    <input type="email" name="email" class="form-control" placeholder="email@contoh.com">
                </div>

                <div class="form-group mb-3">
                    <label for="subject">Subjek</label>
                    <input type="text" name="subject" class="form-control" placeholder="Subjek Pesan Anda">
                </div>

                <div class="form-group mb-4">
                    <label for="message">Pesan</label>
                    <textarea name="message" class="form-control" rows="6" placeholder="Tuliskan pesan Anda di sini..."></textarea>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn submit-btn w-100">
                        <i class="fas fa-paper-plane"></i> Kirim Pesan
                    </button>
                </div>

            </form>

        </div>
        
        <div class="col-md-6 mb-4">
            <div class="info-section">
                <h4>Informasi Kontak Madani Yatsi</h4>
                
                <div class="contact-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <div>
                        <strong>Alamat Kantor:</strong><br>
                        <span>Jl. Aria Santika No.40A, RT.005/RW.011, Margasari, Kec. Karawaci, Kota Tangerang, Banten 15114</span>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <div>
                        <strong>Telepon/WhatsApp:</strong><br>
                        <span>(021) 55726558</span>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <div>
                        <strong>Email Resmi:</strong><br>
                        <span>madaniyatsicreativityindustry@gmail.com</span>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fas fa-clock"></i>
                    <div>
                        <strong>Jam Kerja:</strong><br>
                        <span>Senin - Jumat, 09:00 - 17:00 WIB</span>
                    </div>
                </div>
                
                <p class="mt-4" style="font-size: 0.9rem; color: <?php echo $color_c; ?>;">
                    Kami akan merespons pesan Anda secepatnya dalam 1x24 jam kerja.
                </p>

            </div>
        </div>
        
    </div>
</div>

<?= $this->endSection() ?>