<?php
// Definisikan variabel warna baru sesuai palet yang diberikan
$color_d = '#00473e';   // Headline (Hijau Tua - Judul & Teks Utama)
$color_h = '#faae2b';   // Button/Highlight (Kuning Oranye - Garis Aksen & Link)
$color_c = '#ffa8ba';   // Secondary (Pink Muda - Metadata & Tombol)

// Warna tambahan dari palet
$color_text = '#475d5b'; // Paragraph Text (Teks Konten Utama)
?>

<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<style>
    /* Styling Kustom untuk Halaman Detail Berita */
    .article-container {
        padding: 40px 0;
    }
    .article-title {
        /* Warna D (Hijau Tua) untuk Judul */
        color: <?php echo $color_d; ?>; 
        font-weight: 700;
        margin-bottom: 10px;
        line-height: 1.3;
    }
    .article-meta {
        font-size: 0.95rem;
        /* Warna C (Pink Muda) untuk Metadata */
        color: <?php echo $color_c; ?>; 
        margin-bottom: 25px;
        display: block;
        padding-bottom: 15px;
        /* Garis Aksen Warna H (Kuning Oranye) */
        border-bottom: 2px solid <?php echo $color_h; ?>; 
    }
    .article-content {
        line-height: 1.8; 
        font-size: 1.1rem;
        /* Teks konten menggunakan warna Paragraph baru */
        color: <?php echo $color_text; ?>; 
    }
    /* Styling untuk elemen dalam konten jika ada */
    .article-content p {
        margin-bottom: 1.5rem;
    }
    .article-content strong, .article-content b {
        /* Menekankan teks tebal dengan Warna D (Hijau Tua) */
        color: <?php echo $color_d; ?>; 
    }
    .article-content a {
        /* Link dalam konten menggunakan Warna H (Kuning Oranye) */
        color: <?php echo $color_h; ?>; 
        text-decoration: none;
        border-bottom: 1px dashed <?php echo $color_h; ?>;
    }
    .article-content a:hover {
        /* Hover link menggunakan Warna D (Hijau Tua) */
        color: <?php echo $color_d; ?>;
        border-bottom: 1px solid <?php echo $color_d; ?>;
    }
    /* Tambahan: Styling untuk box detail pegawai */
    .employee-detail-box {
        margin-top: 20px;
        margin-bottom: 40px;
        padding: 15px;
        border: 1px solid #eee;
        border-radius: 8px;
        background-color: #f9f9f9;
    }
    .employee-detail-box img {
        width: 100%;
        max-width: 150px;
        height: auto;
        object-fit: cover;
        border-radius: 4px; /* Sedikit sentuhan visual */
    }
</style>


<div class="container article-container">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <h1 class="h3 article-title">
                <?= $news['nama_pegawai'] ?>
            </h1>
            
            <span class="article-meta">
                Dipublikasikan pada: <?= date('d M Y', strtotime($news['created_at'])) ?>
            </span>
            
            <div class="row mb-4 employee-detail-box">
                <div class="col-md-4 text-center">
                    <?php 
                    // Path folder di server adalah public/img/pegawai/
                    $fotoPath = 'img/pegawai/' . $news['foto_pegawai'];
                    
                    // Cek: Apakah nama file foto di DB ada DAN file tersebut benar-benar ada di folder public/img/pegawai/
                    if (!empty($news['foto_pegawai']) && file_exists(FCPATH . $fotoPath)): 
                    ?>
                        <img src="/<?= $fotoPath ?>" class="img-fluid rounded" alt="Foto <?= $news['nama_pegawai'] ?>">
                    <?php else: ?>
                        <img src="/img/default_avatar.png" class="img-fluid rounded" alt="Tidak Ada Foto">
                    <?php endif; ?>
                </div>
                <div class="col-md-8 pt-3 pt-md-0">
                    <p>
                        <strong>Tanggal Lahir:</strong> 
                        <?= date('d F Y', strtotime($news['tanggal_lahir'])) ?>
                    </p>
                    <p>
                        <strong>Jenis Kelamin:</strong> 
                        <?= $news['jenis_kelamin'] ?>
                    </p>
                </div>
            </div>

            <div class="article-content">
                <?= $news['content'] ?>
            </div>
            
            
            <div class="mt-5 pt-3" style="border-top: 1px solid <?php echo $color_c; ?>;">
                <a href="/news" class="btn" style="background-color: <?php echo $color_c; ?>; color: <?php echo $color_d; ?>; font-weight: 600;">
                    <i class="fas fa-arrow-left"></i> Kembali ke Data Pegawai
                </a>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
