<?php

use CodeIgniter\Router\RouteCollection;

/** @var RouteCollection $routes */

$routes->get('/', 'Home::index');

// Frontend (non-admin) routes
$routes->get('biodata', 'Biodata::index');
$routes->get('pendidikan', 'Pendidikan::index');
$routes->get('aktivitas', 'AktivitasController::index');

$routes->get('admin/login', 'Admin\Auth::login');      // form login
$routes->post('admin/login', 'Admin\Auth::process');  // proses login
$routes->get('admin/logout', 'Admin\Auth::logout');   // logout


// Admin routes
$routes->group('admin', ['namespace' => 'App\Controllers\Admin'], function($routes){

    // Dashboard
    $routes->get('dashboard', 'Dashboard::index');

    // Biodata CRUD
    $routes->get('biodata', 'Biodata::index');
    $routes->get('biodata/edit/(:num)', 'Biodata::edit/$1');
    $routes->post('biodata/update/(:num)', 'Biodata::update/$1');

    // Pendidikan CRUD
    $routes->get('pendidikan', 'Pendidikan::index');
    $routes->get('pendidikan/create', 'Pendidikan::create');
    $routes->post('pendidikan/store', 'Pendidikan::store');
    $routes->get('pendidikan/edit/(:num)', 'Pendidikan::edit/$1');
    $routes->post('pendidikan/update/(:num)', 'Pendidikan::update/$1');
    $routes->get('pendidikan/delete/(:num)', 'Pendidikan::delete/$1');
    $routes->get('pendidikan/show/(:num)', 'Pendidikan::show/$1');

    // Aktivitas CRUD
    $routes->get('aktivitas', 'Aktivitas::index');
    $routes->get('aktivitas/create', 'Aktivitas::create');
    $routes->post('aktivitas/store', 'Aktivitas::store');
    $routes->get('aktivitas/edit/(:num)', 'Aktivitas::edit/$1');
    $routes->post('aktivitas/update/(:num)', 'Aktivitas::update/$1');
    $routes->get('aktivitas/delete/(:num)', 'Aktivitas::delete/$1');
    $routes->get('aktivitas/show/(:num)', 'Aktivitas::show/$1');

    $routes->get('logout', 'Auth::logout');


});

$routes->setAutoRoute(true);
