<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\BiodataModel;
use App\Models\PendidikanModel;
use App\Models\AktivitasModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $session = session();

        // Proteksi: jika belum login, redirect ke halaman login
        if(!$session->get('admin_logged_in')){
            return redirect()->to(base_url('admin/login'));
        }

        $biodataModel    = new BiodataModel();
        $pendidikanModel = new PendidikanModel();
        $aktivitasModel  = new AktivitasModel();

        $data = [
            'admin_username'     => $session->get('admin_username'),
            'stat_biodata'       => $biodataModel->countAllResults(),
            'stat_pendidikan'    => $pendidikanModel->countAllResults(),
            'stat_aktivitas'     => $aktivitasModel->countAllResults(),
            'stat_total_aktivitas' => $aktivitasModel->countAllResults(),
            'last_login'         => $session->get('admin_login_time') ? date('d M Y', $session->get('admin_login_time')) : date('d M Y'),
        ];

        return view('admin/dashboard', $data);
    }
}
