<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class AktivitasController extends BaseController
{
    protected $aktivitas;

    public function __construct()
    {
        $this->aktivitas = new AktivitasModel();
    }

    public function index()
    {
        $keyword      = $this->request->getGet('keyword');
        $sortParamRaw = $this->request->getGet('sort');
        $sortParam    = strtolower($sortParamRaw ?? 'default');
        $sort         = ($sortParam === 'asc') ? 'ASC' : 'DESC';
        $selectedSort = in_array($sortParam, ['asc', 'desc'], true) ? $sortParam : 'default';

        $perPage  = 6;
        $builder  = $this->aktivitas;

        if ($keyword) {
            $builder = $builder->like('nama_aktivitas', $keyword);
        }

        $aktivitas = $builder
            ->orderBy('tanggal', $sort)
            ->orderBy('jam', $sort)
            ->paginate($perPage, 'aktivitas');

        return view('aktivitas', [
            'aktivitas' => $aktivitas,
            'pager'     => $this->aktivitas->pager,
            'sort'      => $selectedSort,
            'keyword'   => $keyword ?? ''
        ]);
    }
}
