<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikan;

    public function __construct()
    {
        $this->pendidikan = new PendidikanModel();
    }

    public function index()
    {
        $keyword      = $this->request->getGet('keyword');
        $sortParamRaw = $this->request->getGet('sort');
        $sortParam    = strtolower($sortParamRaw ?? 'default');
        $selectedSort = in_array($sortParam, ['asc', 'desc'], true) ? $sortParam : 'default';
        $sort         = ($sortParam === 'asc') ? 'asc' : 'desc';

        $builder = $this->pendidikan;

        if ($keyword) {
            $builder = $builder
                ->groupStart()
                ->like('jenjang', $keyword)
                ->orLike('nama_sekolah', $keyword)
                ->groupEnd();
        }

        $riwayat = $builder
            ->orderBy('tahun_mulai', $sort)
            ->findAll();

        return view('pendidikan', [
            'riwayat' => $riwayat,
            'keyword' => $keyword ?? '',
            'sort'    => $selectedSort
        ]);
    }
}
