<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="aktivitas-page">
    <div class="container-fluid">

        <div class="hero d-flex flex-column flex-lg-row align-items-start align-items-lg-center justify-content-between mb-4">
            <div>
                <p class="eyebrow">Log Harian</p>
                <h2 class="mb-1">Aktivitas Harian</h2>
                <p class="subtitle">Pantau dan kelola aktivitas.</p>
            </div>
            <div class="d-flex flex-column flex-lg-row gap-2 mt-3 mt-lg-0">
                <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-ghost">
                    <i class="bi bi-layout-text-sidebar me-2"></i>Dashboard
                </a>
                <a href="<?= base_url('admin/aktivitas/create') ?>" class="btn btn-cta">
                    <i class="bi bi-plus-circle me-2"></i>Tambah Aktivitas
                </a>
            </div>
        </div>

        <div class="card glass filter-card mb-3">
            <form method="get" class="row g-3 align-items-end">
                <div class="col-md-5">
                    <label class="form-label">Cari Aktivitas</label>
                    <input type="text"
                           name="keyword"
                           value="<?= esc($keyword ?? '') ?>"
                           class="form-control"
                           placeholder="Cari nama aktivitas...">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Urutkan Tanggal</label>
                    <select name="sort" class="form-select">
                        <option value="DESC" <?= (($_GET['sort'] ?? '') == 'DESC') ? 'selected' : '' ?>>Terbaru ke Terlama</option>
                        <option value="ASC" <?= (($_GET['sort'] ?? '') == 'ASC') ? 'selected' : '' ?>>Terlama ke Terbaru</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex gap-2">
                    <button class="btn btn-cta w-100" type="submit">
                        <i class="bi bi-search"></i> Terapkan
                    </button>
                    <a href="<?= base_url('admin/aktivitas') ?>" class="btn btn-ghost w-100">Reset</a>
                </div>
            </form>
        </div>

        <div class="card glass table-card mb-4">
            <?php if (empty($aktivitas)): ?>
                <div class="text-center text-muted p-5">
                    <i class="bi bi-inbox fs-1"></i>
                    <h6 class="mt-2">Belum ada aktivitas</h6>
                </div>
            <?php else: ?>
            <?php
                $currentPage = $pager->getCurrentPage('default');
                $perPage     = $pager->getPerPage('default');
                $total       = $pager->getTotal('default');
                $startNumber = ($perPage * ($currentPage - 1)) + 1;
                $endNumber   = min($startNumber + count($aktivitas) - 1, $total);
            ?>

            <div class="table-responsive">
                <table class="table table-borderless align-middle mb-0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Foto</th>
                            <th>Tanggal</th>
                            <th>Jam</th>
                            <th>Nama Aktivitas</th>
                            <th class="text-end">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($aktivitas as $i => $row): ?>
                        <tr>
                            <td><?= $startNumber + $i ?></td>
                            <td>
                                <?php if (!empty($row['media'])): ?>
                                    <img src="<?= base_url('uploads/aktivitas/'.$row['media']) ?>" class="thumb" alt="Foto aktivitas">
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td><?= date('d M Y', strtotime($row['tanggal'])) ?></td>
                            <td><?= date('H:i', strtotime($row['jam'])) ?></td>
                            <td class="fw-semibold"><?= esc($row['nama_aktivitas']) ?></td>
                            <td class="text-end d-flex flex-wrap gap-2 justify-content-end">
                                <a href="<?= base_url('admin/aktivitas/show/'.$row['id']) ?>" class="btn btn-ghost btn-sm">
                                    <i class="bi bi-eye me-1"></i>Preview
                                </a>
                                <a href="<?= base_url('admin/aktivitas/edit/'.$row['id']) ?>" class="btn btn-cta btn-sm">
                                    <i class="bi bi-pencil-square me-1"></i>Edit
                                </a>
                                <a href="<?= base_url('admin/aktivitas/delete/'.$row['id']) ?>"
                                   onclick="return confirm('Yakin hapus data?')"
                                   class="btn btn-ghost btn-sm danger">
                                    <i class="bi bi-trash me-1"></i>Hapus
                                </a>
                            </td>
                        </tr>
                        <?php endforeach ?>
                    </tbody>
                </table>
            </div>
            <div class="pagination-card glass mt-3 d-flex flex-column flex-lg-row align-items-lg-center gap-3 justify-content-between">
                <div class="text-muted small fw-semibold">
                    Menampilkan <?= $startNumber ?> - <?= $endNumber ?> dari <?= $total ?> aktivitas
                </div>
                <div class="pagination-pill">
                    <?= $pager->links() ?>
                </div>
            </div>
            <?php endif ?>
        </div>

    </div>
</div>

<style>
:root {
    --bg: #0e0a1f;
    --card: rgba(255, 255, 255, 0.05);
    --border: rgba(255, 255, 255, 0.08);
    --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
}

body {
    background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                var(--bg);
    color: #e5e7eb;
}

.aktivitas-page { padding: 24px; }
.aktivitas-page h1,
.aktivitas-page h2,
.aktivitas-page h3,
.aktivitas-page h4,
.aktivitas-page h5,
.aktivitas-page h6 { color: #f8fafc; }
.aktivitas-page p,
.aktivitas-page small { color: #e7e9ef; }
.aktivitas-page .text-muted { color: #e2e8f0 !important; }

.hero {
    background: linear-gradient(135deg, rgba(236,72,153,0.26), rgba(139,92,246,0.26));
    border: 1px solid var(--border);
    border-radius: 18px;
    padding: 22px;
    box-shadow: var(--glow);
}

.eyebrow {
    letter-spacing: 0.1em;
    text-transform: uppercase;
    font-size: 0.82rem;
    color: #fbcfe8;
    margin-bottom: 6px;
}

.subtitle { color: #cbd5e1; max-width: 520px; }

.btn-cta {
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
    border: none;
    color: #fff;
    border-radius: 12px;
    font-weight: 700;
}
.btn-cta:hover { filter: brightness(1.05); }
.btn-cta.btn-sm { padding: 6px 12px; font-weight: 600; }

.btn-ghost {
    color: #f8fafc;
    border: 1px solid rgba(255,255,255,0.35);
    border-radius: 12px;
    font-weight: 600;
    background: rgba(255,255,255,0.08);
}
.btn-ghost.danger { color: #fecdd3; border-color: rgba(248,113,113,0.65); background: rgba(127,29,29,0.22); }
.btn-ghost.btn-sm { padding: 6px 12px; }

.glass {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 18px;
    box-shadow: var(--glow);
    backdrop-filter: blur(10px);
}

.filter-card { padding: 18px; }
.form-label { color: #e5e7eb; font-weight: 600; }
.form-control,
.form-select {
    background: rgba(255,255,255,0.04);
    border: 1px solid var(--border);
    color: #e5e7eb;
}
.form-control:focus,
.form-select:focus {
    border-color: rgba(236,72,153,0.6);
    box-shadow: 0 0 0 0.2rem rgba(236,72,153,0.18);
    background: rgba(255,255,255,0.08);
}

.table-card { padding: 18px; background: rgba(18,18,36,0.75); }

.table thead th {
    color: #f8fafc;
    background: rgba(29,31,44,0.9);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    font-size: 0.8rem;
    border-color: var(--border);
}

.table tbody td {
    color: #f8fafc;
    border-color: rgba(255,255,255,0.08);
    background: transparent;
}

.table tbody tr {
    background: rgba(19,20,35,0.75);
}

.table tbody tr:nth-child(even) {
    background: rgba(26,28,46,0.8);
}

.table tbody tr:hover {
    background: rgba(38,40,66,0.9);
    transition: background 0.2s ease;
}

.pagination-card {
    padding: 14px 16px;
    border: 1px solid var(--border);
    border-radius: 14px;
    background: linear-gradient(135deg, rgba(236,72,153,0.08), rgba(139,92,246,0.08));
}

.pagination {
    display: flex;
    gap: 10px;
    align-items: center;
    justify-content: center;
    padding: 0;
    margin: 0;
    list-style: none;
    flex-wrap: wrap;
}

.pagination li {
    list-style: none;
}

.pagination li a {
    display: flex;
    align-items: center;
    justify-content: center;
    min-width: 44px;
    padding: 10px 14px;
    border-radius: 12px;
    border: 1px solid var(--border);
    background: rgba(255,255,255,0.04);
    color: #f8fafc;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.01em;
    transition: all 0.2s ease;
    box-shadow: 0 10px 24px rgba(0,0,0,0.18);
}

.pagination li a:hover {
    border-color: rgba(236,72,153,0.65);
    background: rgba(255,255,255,0.08);
    transform: translateY(-1px);
}

.pagination li.active a {
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
    border: none;
    color: #fff;
    box-shadow: var(--glow);
}

.thumb {
    width: 64px;
    height: 64px;
    border-radius: 12px;
    object-fit: cover;
    border: 2px solid rgba(255,255,255,0.18);
}

@media (max-width: 768px) {
    .aktivitas-page { padding: 18px 14px 32px; }
    .hero { padding: 18px; }
    .filter-card { padding: 14px; }
    .table-card { padding: 12px; }
}
</style>

<?= $this->endSection() ?>
