<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --bg: #0e0a1f;
            --card: rgba(255, 255, 255, 0.06);
            --border: rgba(255, 255, 255, 0.12);
            --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
        }

        * { box-sizing: border-box; }

        body {
            min-height: 100vh;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                        radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                        radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                        var(--bg);
            color: #e5e7eb;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            overflow: hidden;
        }

        .bubble {
            position: absolute;
            width: 280px;
            height: 280px;
            filter: blur(60px);
            opacity: 0.35;
            z-index: 0;
        }
        .bubble.pink { background: #ec4899; top: -80px; left: -60px; }
        .bubble.purple { background: #8b5cf6; bottom: -120px; right: -40px; }

        .login-wrapper {
            position: relative;
            z-index: 1;
            width: 100%;
            max-width: 380px;
            padding: 20px;
        }

        .login-card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 22px;
            padding: 32px 28px;
            box-shadow: var(--glow);
            backdrop-filter: blur(14px);
        }

        .login-card h3 {
            font-weight: 800;
            margin-bottom: 8px;
            color: #f8fafc;
            text-align: center;
        }

        .login-subtitle {
            color: #cbd5e1;
            text-align: center;
            margin-bottom: 24px;
        }

        .login-icon {
            width: 56px;
            height: 56px;
            border-radius: 16px;
            display: grid;
            place-items: center;
            margin: 0 auto 18px auto;
            background: linear-gradient(135deg, rgba(236,72,153,0.35), rgba(139,92,246,0.35));
            border: 1px solid var(--border);
            color: #f8fafc;
            box-shadow: var(--glow);
            font-size: 1.8rem;
        }

        label.form-label { color: #e5e7eb; font-weight: 600; }

        .form-control {
            background: rgba(255,255,255,0.04);
            border: 1px solid var(--border);
            color: #e5e7eb;
            border-radius: 12px;
            padding: 12px 14px;
        }
        .form-control:focus {
            border-color: rgba(236,72,153,0.6);
            box-shadow: 0 0 0 0.2rem rgba(236,72,153,0.18);
            background: rgba(255,255,255,0.08);
        }

        .btn-login {
            background: linear-gradient(135deg, #ec4899, #8b5cf6);
            color: #fff;
            font-weight: 700;
            width: 100%;
            padding: 12px 0;
            border-radius: 12px;
            border: none;
            letter-spacing: 0.02em;
            box-shadow: var(--glow);
        }
        .btn-login:hover { filter: brightness(1.05); }

        .alert-danger {
            font-size: 0.9rem;
            background: rgba(127,29,29,0.35);
            color: #fecdd3;
            border: 1px solid rgba(248,113,113,0.65);
        }

        @media (max-width: 575px) {
            .login-wrapper { padding: 16px; }
            .login-card { padding: 28px 22px; }
        }
    </style>
</head>
<body>

<div class="bubble pink"></div>
<div class="bubble purple"></div>

<div class="login-wrapper">
    <div class="login-card glass">
        <div class="login-icon">
            <i class="bi bi-shield-lock-fill"></i>
        </div>
        <h3>Login Admin</h3>
        <p class="login-subtitle">Masuk ke dashboard admin.</p>

        <?php if(session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('admin/login') ?>" method="post">
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <input type="text" class="form-control" id="username" name="username" required autofocus>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-control" id="password" name="password" required>
            </div>
            <button type="submit" class="btn-login">Login <i class="bi bi-box-arrow-in-right ms-2"></i></button>
        </form>
    </div>
</div>

</body>
</html>
