<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="pendidikan-page">
    <div class="container-fluid">

        <div class="hero d-flex flex-column flex-lg-row align-items-start align-items-lg-center justify-content-between mb-4">
            <div>
                <p class="eyebrow">Data Akademik</p>
                <h2 class="mb-1">Riwayat Pendidikan</h2>
                <p class="subtitle">Kelola jenjang pendidikan.</p>
            </div>
            <div class="d-flex flex-column flex-lg-row gap-2 mt-3 mt-lg-0">
                <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-ghost">
                    <i class="bi bi-layout-text-sidebar me-2"></i>Dashboard
                </a>
                <a href="<?= base_url('admin/pendidikan/create') ?>" class="btn btn-cta">
                    <i class="bi bi-plus-circle me-2"></i>Tambah Pendidikan
                </a>
            </div>
        </div>

        <div class="card glass table-card">
            <div class="table-responsive">
                <table class="table table-borderless align-middle mb-0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Foto</th>
                            <th>Jenjang</th>
                            <th>Nama Sekolah</th>
                            <th>Tahun</th>
                            <th class="text-end">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach($pendidikan as $i => $row): ?>
                        <tr>
                            <td><?= $i+1 ?></td>

                            <td>
                                <?php if($row['foto']): ?>
                                    <img src="<?= base_url('uploads/pendidikan/'.$row['foto']) ?>"
                                         class="thumb" alt="Foto jenjang">
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif ?>
                            </td>

                            <td><?= esc($row['jenjang']) ?></td>
                            <td><?= esc($row['nama_sekolah']) ?></td>
                            <td><?= $row['tahun_mulai'] ?> - <?= $row['tahun_selesai'] ?></td>

                            <td class="text-end d-flex flex-wrap gap-2 justify-content-end">
                                <a href="<?= base_url('admin/pendidikan/show/'.$row['id']) ?>" class="btn btn-ghost btn-sm">
                                    <i class="bi bi-eye me-1"></i>Preview
                                </a>
                                <a href="<?= base_url('admin/pendidikan/edit/'.$row['id']) ?>" class="btn btn-cta btn-sm">
                                    <i class="bi bi-pencil-square me-1"></i>Edit
                                </a>
                                <a href="<?= base_url('admin/pendidikan/delete/'.$row['id']) ?>"
                                   onclick="return confirm('Hapus data?')"
                                   class="btn btn-ghost btn-sm danger">
                                    <i class="bi bi-trash me-1"></i>Delete
                                </a>
                            </td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<style>
:root {
    --bg: #0e0a1f;
    --card: rgba(255, 255, 255, 0.05);
    --border: rgba(255, 255, 255, 0.08);
    --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
}

body {
    background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                var(--bg);
    color: #e5e7eb;
}

.pendidikan-page { padding: 24px; }
.pendidikan-page h1,
.pendidikan-page h2,
.pendidikan-page h3,
.pendidikan-page h4,
.pendidikan-page h5,
.pendidikan-page h6 { color: #f8fafc; }
.pendidikan-page p,
.pendidikan-page small { color: #e7e9ef; }
.pendidikan-page .text-muted { color: #e2e8f0 !important; }

.hero {
    background: linear-gradient(135deg, rgba(236,72,153,0.26), rgba(139,92,246,0.26));
    border: 1px solid var(--border);
    border-radius: 18px;
    padding: 22px;
    box-shadow: var(--glow);
}

.eyebrow {
    letter-spacing: 0.1em;
    text-transform: uppercase;
    font-size: 0.82rem;
    color: #fbcfe8;
    margin-bottom: 6px;
}

.subtitle { color: #cbd5e1; max-width: 520px; }

.btn-cta {
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
    border: none;
    color: #fff;
    border-radius: 12px;
    font-weight: 700;
}
.btn-cta:hover { filter: brightness(1.05); }
.btn-cta.btn-sm { padding: 6px 12px; font-weight: 600; }

.btn-ghost {
    color: #e5e7eb;
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 12px;
    font-weight: 600;
    background: rgba(255,255,255,0.03);
}
.btn-ghost.danger { color: #fecdd3; border-color: rgba(248,113,113,0.35); }
.btn-ghost.btn-sm { padding: 6px 12px; }

.glass {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 18px;
    box-shadow: var(--glow);
    backdrop-filter: blur(10px);
}

.table-card { padding: 18px; background: rgba(18,18,36,0.75); }

.table thead th {
    color: #f8fafc;
    background: rgba(29,31,44,0.9);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    font-size: 0.8rem;
    border-color: var(--border);
}

.table tbody td {
    color: #f8fafc;
    border-color: rgba(255,255,255,0.08);
    background: transparent;
}

.table tbody tr {
    background: rgba(19,20,35,0.75);
}

.table tbody tr:nth-child(even) {
    background: rgba(26,28,46,0.8);
}

.table tbody tr:hover {
    background: rgba(38,40,66,0.9);
    transition: background 0.2s ease;
}

.btn-ghost {
    color: #f8fafc;
    border: 1px solid rgba(255,255,255,0.35);
    border-radius: 12px;
    font-weight: 600;
    background: rgba(255,255,255,0.08);
}
.btn-ghost.danger { color: #fecdd3; border-color: rgba(248,113,113,0.65); background: rgba(127,29,29,0.22); }

.thumb {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    object-fit: cover;
    border: 2px solid rgba(255,255,255,0.18);
}

@media (max-width: 768px) {
    .pendidikan-page { padding: 18px 14px 32px; }
    .hero { padding: 18px; }
    .table-card { padding: 12px; }
}
</style>

<?= $this->endSection() ?>
