<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="pendidikan-page">
    <div class="container-fluid">
        <div class="hero d-flex flex-column flex-lg-row align-items-start align-items-lg-center justify-content-between mb-4">
            <div>
                <p class="eyebrow">Data Akademik</p>
                <h2 class="mb-1">Detail Pendidikan</h2>
                <p class="subtitle">Pratinjau.</p>
            </div>
            <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-ghost mt-3 mt-lg-0">
                <i class="bi bi-arrow-left me-2"></i>Kembali
            </a>
        </div>

        <div class="card glass form-card">
            <div class="row g-3">
                <div class="col-12 col-md-4 text-center">
                    <?php if(!empty($row['foto'])): ?>
                        <img src="<?= base_url('uploads/pendidikan/'.$row['foto']) ?>" class="preview-img" alt="Foto Pendidikan">
                    <?php else: ?>
                        <div class="preview-placeholder">Tidak ada foto</div>
                    <?php endif; ?>
                </div>
                <div class="col-12 col-md-8">
                    <div class="detail-item">
                        <p class="label">Jenjang</p>
                        <h4><?= esc($row['jenjang']) ?></h4>
                    </div>
                    <div class="detail-item">
                        <p class="label">Nama Sekolah</p>
                        <h5><?= esc($row['nama_sekolah']) ?></h5>
                    </div>
                    <div class="detail-item">
                        <p class="label">Tahun</p>
                        <p><?= esc($row['tahun_mulai']) ?> - <?= esc($row['tahun_selesai']) ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
:root {
    --bg: #0e0a1f;
    --card: rgba(255, 255, 255, 0.05);
    --border: rgba(255, 255, 255, 0.08);
    --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
}

body {
    background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                var(--bg);
    color: #e5e7eb;
}

.pendidikan-page { padding: 24px; }
.pendidikan-page h1,
.pendidikan-page h2,
.pendidikan-page h3,
.pendidikan-page h4,
.pendidikan-page h5,
.pendidikan-page h6 { color: #f8fafc; }
.pendidikan-page p,
.pendidikan-page small { color: #e7e9ef; }
.pendidikan-page .text-muted { color: #e2e8f0 !important; }

.hero {
    background: linear-gradient(135deg, rgba(236,72,153,0.26), rgba(139,92,246,0.26));
    border: 1px solid var(--border);
    border-radius: 18px;
    padding: 22px;
    box-shadow: var(--glow);
}

.eyebrow {
    letter-spacing: 0.1em;
    text-transform: uppercase;
    font-size: 0.82rem;
    color: #fbcfe8;
    margin-bottom: 6px;
}

.subtitle { color: #cbd5e1; max-width: 520px; }

.btn-ghost {
    color: #e5e7eb;
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 12px;
    font-weight: 600;
}

.glass {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 18px;
    box-shadow: var(--glow);
    backdrop-filter: blur(10px);
}

.form-card { padding: 22px; }
.label { letter-spacing: 0.08em; text-transform: uppercase; font-size: 0.8rem; color: #cbd5e1; margin-bottom: 6px; }
.detail-item { margin-bottom: 14px; }

.preview-img {
    width: 100%;
    max-width: 220px;
    border-radius: 16px;
    border: 2px solid rgba(255,255,255,0.18);
    box-shadow: var(--glow);
    object-fit: cover;
}
.preview-placeholder {
    width: 100%;
    max-width: 220px;
    height: 160px;
    border-radius: 16px;
    border: 1px dashed var(--border);
    display: grid;
    place-items: center;
    color: #cbd5e1;
    background: rgba(255,255,255,0.04);
}

@media (max-width: 768px) {
    .pendidikan-page { padding: 18px 14px 32px; }
    .hero { padding: 18px; }
    .form-card { padding: 18px; }
    .preview-img, .preview-placeholder { max-width: 180px; }
}
</style>

<?= $this->endSection() ?>
