<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aktivitas Harian - Profil Tiara</title>
    <style>
        :root {
            --bg: #0e0a1f;
            --card: rgba(255, 255, 255, 0.06);
            --border: rgba(255, 255, 255, 0.12);
            --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            font-family: 'Segoe UI', system-ui, sans-serif;
            background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                        radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                        radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                        var(--bg);
            color: #e5e7eb;
            min-height: 100vh;
        }

        nav {
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px 32px;
            backdrop-filter: blur(16px);
            background: rgba(12, 10, 25, 0.7);
            border-bottom: 1px solid var(--border);
        }
        nav .logo { font-weight: 800; letter-spacing: 0.08em; color: #f8fafc; }
        nav a {
            margin-left: 16px;
            text-decoration: none;
            color: #e5e7eb;
            font-weight: 600;
            padding: 10px 14px;
            border-radius: 12px;
        }
        nav a:hover { background: rgba(255,255,255,0.08); }

        .layout {
            max-width: 1000px;
            margin: 32px auto 80px;
            padding: 0 24px;
        }

        .card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 22px;
            padding: 26px;
            box-shadow: var(--glow);
            backdrop-filter: blur(12px);
        }

        h1 { margin: 0 0 8px; color: #f8fafc; }
        .subtitle { color: #cbd5e1; margin: 0 0 20px; }
        .eyebrow { letter-spacing: 0.08em; text-transform: uppercase; font-size: 12px; color: #fbcfe8; margin: 0 0 10px; }

        .filters {
            display: grid;
            grid-template-columns: 1fr 170px 110px;
            gap: 10px;
            margin: 14px 0 18px;
        }
        .filters input,
        .filters select,
        .filters button {
            padding: 12px 12px;
            border-radius: 12px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.05);
            color: #f8fafc;
        }
        .filters input::placeholder { color: #94a3b8; }
        .filters select option { color: #0f172a; background: #fff; }
        .filters button {
            font-weight: 700;
            cursor: pointer;
            box-shadow: 0 10px 24px rgba(0,0,0,0.18);
            transition: filter 0.2s ease, transform 0.2s ease;
        }
        .filters button:hover { filter: brightness(1.05); transform: translateY(-1px); }

        .timeline {
            position: relative;
            padding-left: 24px;
        }
        .timeline::before {
            content: '';
            position: absolute;
            top: 0;
            left: 6px;
            width: 2px;
            height: 100%;
            background: linear-gradient(180deg, rgba(236,72,153,0.35), rgba(139,92,246,0.35));
        }
        .item {
            position: relative;
            margin-bottom: 14px;
            padding: 16px 18px 16px 24px;
            border-radius: 16px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.03);
            display: grid;
            grid-template-columns: auto 1fr;
            gap: 12px;
        }
        .item::before {
            content: '';
            position: absolute;
            width: 12px;
            height: 12px;
            background: linear-gradient(135deg, #ec4899, #8b5cf6);
            border-radius: 50%;
            left: -1px;
            top: 18px;
            box-shadow: var(--glow);
        }
        .thumb {
            width: 90px;
            height: 90px;
            border-radius: 14px;
            object-fit: cover;
            border: 1px solid var(--border);
            box-shadow: var(--glow);
        }
        .thumb-placeholder {
            width: 90px;
            height: 90px;
            border-radius: 14px;
            border: 1px dashed var(--border);
            display: grid;
            place-items: center;
            color: #94a3b8;
            font-size: 12px;
        }
        .time { color: #cbd5e1; font-weight: 700; margin: 0; }
        .title { margin: 2px 0 4px; color: #f8fafc; font-size: 17px; }
        .date { color: #94a3b8; margin: 0; }

        .pagination-card {
            padding: 14px 16px;
            border: 1px solid var(--border);
            border-radius: 14px;
            background: linear-gradient(135deg, rgba(236,72,153,0.08), rgba(139,92,246,0.08));
            margin-top: 14px;
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
            align-items: center;
            justify-content: space-between;
        }
        .pagination {
            display: flex;
            gap: 10px;
            align-items: center;
            padding: 0;
            margin: 0;
            list-style: none;
            flex-wrap: wrap;
        }
        .pagination li a {
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 44px;
            padding: 10px 14px;
            border-radius: 12px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.04);
            color: #f8fafc;
            text-decoration: none;
            font-weight: 700;
            letter-spacing: 0.01em;
            transition: all 0.2s ease;
            box-shadow: 0 10px 24px rgba(0,0,0,0.18);
        }
        .pagination li a:hover {
            border-color: rgba(236,72,153,0.65);
            background: rgba(255,255,255,0.08);
            transform: translateY(-1px);
        }
        .pagination li.active a {
            background: linear-gradient(135deg, #ec4899, #8b5cf6);
            border: none;
            color: #fff;
            box-shadow: var(--glow);
        }

        footer {
            text-align: center;
            padding: 18px;
            color: #cbd5e1;
            border-top: 1px solid var(--border);
            background: rgba(12, 10, 25, 0.7);
        }

        @media (max-width: 640px) {
            nav { padding: 12px 18px; }
            .layout { padding: 0 18px; }
            .filters { grid-template-columns: 1fr; }
            .item { grid-template-columns: 1fr; }
            nav { flex-direction: column; align-items: flex-start; gap: 8px; }
            nav a { margin-left: 0; }
            .thumb, .thumb-placeholder { width: 72px; height: 72px; }
            .card { padding: 20px; }
        }
    </style>
</head>
<body>

<nav>
    <div class="logo">PROFIL TIARA</div>
    <div>
        <a href="/">Home</a>
        <a href="/biodata">Biodata</a>
        <a href="/pendidikan">Pendidikan</a>
        <a href="/aktivitas">Aktivitas</a>
    </div>
</nav>

<div class="layout">
    <div class="card">
        <p class="eyebrow">Aktivitas Harian</p>
        <h1>Rangkuman Rutinitas</h1>
        <p class="subtitle">Timeline aktivitas.</p>

        <form method="get" class="filters">
            <input type="text" name="keyword" value="<?= esc($keyword ?? '') ?>" placeholder="Cari aktivitas...">
            <select name="sort" onchange="this.form.submit()">
                <option value="default" <?= (($sort ?? 'default') === 'default') ? 'selected' : '' ?>>Default</option>
                <option value="desc" <?= (($sort ?? '') === 'desc') ? 'selected' : '' ?>>Terbaru</option>
                <option value="asc" <?= (($sort ?? '') === 'asc') ? 'selected' : '' ?>>Terlama</option>
            </select>
            <button type="submit">Cari</button>
        </form>

        <div class="timeline">
            <?php if (empty($aktivitas)): ?>
                <p class="subtitle">Belum ada aktivitas.</p>
            <?php else: ?>
            <?php
                $currentPage = $pager->getCurrentPage('aktivitas');
                $perPage     = $pager->getPerPage('aktivitas');
                $total       = $pager->getTotal('aktivitas');
                $startNumber = ($perPage * ($currentPage - 1)) + 1;
                $endNumber   = min($startNumber + count($aktivitas) - 1, $total);
            ?>
            <?php foreach ($aktivitas as $item): ?>
                <div class="item">
                    <?php if (!empty($item['media'])): ?>
                        <img src="<?= base_url('uploads/aktivitas/'.$item['media']) ?>" alt="Foto aktivitas" class="thumb">
                    <?php else: ?>
                        <div class="thumb-placeholder">Tidak ada foto</div>
                    <?php endif; ?>
                    <div>
                        <p class="time"><?= date('d M Y', strtotime($item['tanggal'])) ?> · <?= date('H:i', strtotime($item['jam'])) ?></p>
                        <p class="title"><?= esc($item['nama_aktivitas']) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <?php if (!empty($aktivitas)): ?>
        <div class="pagination-card">
            <div class="text-muted small fw-semibold">
                Menampilkan <?= $startNumber ?> - <?= $endNumber ?> dari <?= $total ?> aktivitas
            </div>
            <div class="pagination-pill">
                <?= $pager->links('aktivitas') ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<footer>
    © <?= date('Y') ?> Tiara Cahya Kurniawati · Universitas Yatsi Madani
</footer>

</body>
</html>
