<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Tiara</title>

    <style>
        :root {
            --bg: #0e0a1f;
            --card: rgba(255, 255, 255, 0.06);
            --border: rgba(255, 255, 255, 0.12);
            --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            font-family: 'Segoe UI', system-ui, sans-serif;
            background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                        radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                        radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                        var(--bg);
            color: #e5e7eb;
            min-height: 100vh;
        }

        nav {
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px 32px;
            backdrop-filter: blur(16px);
            background: rgba(12, 10, 25, 0.7);
            border-bottom: 1px solid var(--border);
        }

        nav .logo {
            font-weight: 800;
            font-size: 18px;
            color: #f8fafc;
            letter-spacing: 0.08em;
        }

        nav .links {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .burger {
            display: none;
            background: rgba(255,255,255,0.06);
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: 8px 10px;
            color: #f8fafc;
            cursor: pointer;
        }
        .burger span {
            display: block;
            width: 18px;
            height: 2px;
            background: currentColor;
            margin: 4px 0;
        }

        nav a {
            text-decoration: none;
            color: #e5e7eb;
            font-weight: 600;
            padding: 10px 14px;
            border-radius: 12px;
            transition: background 0.2s ease;
        }

        nav a:hover { background: rgba(255,255,255,0.08); }

        .btn-login {
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.06);
            box-shadow: var(--glow);
        }

        .hero {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            align-items: center;
            gap: 40px;
            max-width: 1100px;
            padding: 72px 28px 36px;
            margin: auto;
        }

        .hero-card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 22px;
            padding: 32px;
            box-shadow: var(--glow);
            backdrop-filter: blur(14px);
        }

        .hero h1 {
            font-size: clamp(32px, 4vw, 46px);
            margin: 0 0 14px;
            color: #f8fafc;
        }

        .hero h1 span { color: #ec4899; }

        .hero p {
            color: #cbd5e1;
            line-height: 1.7;
            margin: 0 0 24px;
        }

        .hero-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 12px 18px;
            border-radius: 12px;
            text-decoration: none;
            font-weight: 700;
            border: 1px solid transparent;
            transition: transform 0.15s ease, filter 0.2s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, #ec4899, #8b5cf6);
            color: #fff;
            box-shadow: var(--glow);
        }

        .btn-ghost {
            border: 1px solid var(--border);
            color: #f8fafc;
            background: rgba(255,255,255,0.06);
        }

        .btn:hover { filter: brightness(1.05); transform: translateY(-1px); }

        .hero-img {
            text-align: center;
        }

        .hero-img img {
            width: 320px;
            height: 320px;
            object-fit: cover;
            border-radius: 24px;
            border: 1px solid var(--border);
            box-shadow: var(--glow);
            animation: float 6s ease-in-out infinite;
        }

        .grid {
            max-width: 1100px;
            margin: 12px auto 60px;
            padding: 0 28px;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
            gap: 18px;
        }

        .card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 18px;
            padding: 20px;
            box-shadow: var(--glow);
            backdrop-filter: blur(10px);
        }

        .card h3 { margin: 0 0 10px; color: #f8fafc; }
        .card p { margin: 0 0 12px; color: #cbd5e1; }
        .card a { text-decoration: none; color: #f8fafc; font-weight: 700; }

        .socials {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 16px;
        }
        .socials a {
            padding: 10px 12px;
            border-radius: 10px;
            border: 1px solid var(--border);
            color: #f8fafc;
            text-decoration: none;
            background: rgba(255,255,255,0.05);
            font-weight: 700;
            font-size: 13px;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }
        .socials .icon { width: 16px; height: 16px; display: inline-block; }

        .drawer {
            position: fixed;
            inset: 0;
            background: rgba(0,0,0,0.55);
            backdrop-filter: blur(6px);
            display: none;
            align-items: flex-start;
            justify-content: flex-end;
            z-index: 30;
        }
        .drawer.open { display: flex; }
        .drawer-card {
            width: 240px;
            background: rgba(17, 14, 32, 0.92);
            border-left: 1px solid var(--border);
            padding: 18px;
            display: grid;
            gap: 10px;
            min-height: 100vh;
        }
        .drawer-card .close-btn {
            justify-self: end;
            background: rgba(255,255,255,0.06);
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: 8px 10px;
            color: #f8fafc;
            cursor: pointer;
        }
        .drawer-links {
            display: grid;
            gap: 8px;
        }
        .drawer-links a {
            text-decoration: none;
            color: #e5e7eb;
            padding: 10px 12px;
            border-radius: 10px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.04);
            font-weight: 700;
        }

        footer {
            text-align: center;
            padding: 20px;
            color: #cbd5e1;
            border-top: 1px solid var(--border);
            background: rgba(12, 10, 25, 0.7);
        }

        @media (max-width: 900px) {
            nav {
                flex-direction: row;
                align-items: center;
                gap: 10px;
                padding: 12px 18px;
            }
            .links { display: none; }
            .burger { display: inline-block; }
            .hero {
                padding: 52px 18px 28px;
                gap: 26px;
            }
            .hero-card { padding: 26px; }
            .hero-img img { width: 260px; height: 260px; }
            .grid { padding: 0 18px; }
        }

        @media (max-width: 540px) {
            .hero-card { padding: 22px; }
            .hero-img img { width: 220px; height: 220px; }
            .links a { padding: 8px 10px; }
            .socials a { padding: 8px 10px; }
        }

        @keyframes float {
            0%, 100% { transform: translateY(0) scale(1); }
            50% { transform: translateY(-10px) scale(1.01); }
        }
    </style>
</head>
<body>

<nav>
    <div class="logo">PROFIL TIARA</div>
    <button class="burger" aria-label="Buka menu">
        <span></span>
        <span></span>
        <span></span>
    </button>
    <div class="links">
        <a href="/">Home</a>
        <a href="/biodata">Biodata</a>
        <a href="/pendidikan">Pendidikan</a>
        <a href="/aktivitas">Aktivitas</a>
        <a href="/admin/login" class="btn-login">Login</a>
    </div>
</nav>

<div class="drawer" id="drawer">
    <div class="drawer-card">
        <button class="close-btn" aria-label="Tutup menu">&times;</button>
        <div class="drawer-links">
            <a href="/">Home</a>
            <a href="/biodata">Biodata</a>
            <a href="/pendidikan">Pendidikan</a>
            <a href="/aktivitas">Aktivitas</a>
            <a href="/admin/login">Login</a>
        </div>
    </div>
</div>

<section class="hero">
    <div class="hero-card">
        <p class="eyebrow">Selamat datang</p>
        <h1>Halo, saya <span>Tiara</span></h1>
        <p>Mahasiswa Ilmu Komputer Universitas Yatsi Madani. Website ini adalah etalase biodata, riwayat pendidikan, dan aktivitas harian.</p>
        <div class="socials">
            <a href="https://www.instagram.com/tiara_chyaa/?__pwa=1" target="_blank" aria-label="Instagram">
                <span class="icon" aria-hidden="true">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="3" width="18" height="18" rx="5" ry="5"></rect>
                        <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path>
                        <line x1="17.5" y1="6.5" x2="17.5" y2="6.5"></line>
                    </svg>
                </span>
                Instagram
            </a>
            <a href="https://wa.me/6281292859846" target="_blank" aria-label="WhatsApp">
                <span class="icon" aria-hidden="true">
                    <svg viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13.601 2.326A7.956 7.956 0 0 0 8.043.65C4.109.65 1 3.757 1 7.688c0 1.35.35 2.682 1.014 3.86l-1.1 3.222 3.4-.978a7.58 7.58 0 0 0 3.621.924h.003c3.934 0 7.043-3.107 7.043-7.038a7.012 7.012 0 0 0-2.48-5.352zM8.064 13.142a6.374 6.374 0 0 1-3.247-.892l-.233-.139-2.02.582.582-1.967-.15-.241a6.158 6.158 0 0 1-.952-3.26c0-3.508 2.86-6.363 6.383-6.363a6.31 6.31 0 0 1 4.5 1.869 6.213 6.213 0 0 1 1.89 4.47c0 3.508-2.86 6.363-6.353 6.363zm3.546-4.766c-.194-.097-1.152-.568-1.332-.634-.18-.065-.312-.097-.444.097-.133.194-.51.634-.626.764-.115.13-.231.146-.425.049-.194-.097-.82-.301-1.563-.96-.578-.516-.97-1.154-1.084-1.349-.115-.194-.012-.299.085-.396.087-.086.194-.223.291-.335.097-.112.129-.194.194-.323.065-.13.033-.243-.016-.335-.049-.097-.444-1.07-.608-1.465-.16-.382-.323-.33-.444-.335l-.38-.007c-.13 0-.342.049-.521.243-.18.194-.684.668-.684 1.63 0 .962.7 1.89.797 2.02.098.13 1.38 2.113 3.345 2.963.467.201.83.321 1.114.412.468.149.894.128 1.23.078.375-.056 1.152-.47 1.316-.925.162-.456.162-.846.114-.925-.049-.079-.177-.128-.37-.225z"/>
                    </svg>
                </span>
                WhatsApp
            </a>
            <a href="https://www.linkedin.com/in/tiara-cahya-1a5121398/?lipi=urn%3Ali%3Apage%3Ad_flagship3_feed%3BF40oEYosTku4J4CCMuEvCg%3D%3D" target="_blank" aria-label="LinkedIn">
                <span class="icon" aria-hidden="true">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M16 8a6 6 0 0 1 6 6v6h-4v-6a2 2 0 0 0-4 0v6h-4v-6a6 6 0 0 1 6-6z"></path>
                        <rect x="2" y="9" width="4" height="11"></rect>
                        <circle cx="4" cy="5" r="2"></circle>
                    </svg>
                </span>
                LinkedIn
            </a>
        </div>
    </div>
    <div class="hero-img">
        <img src="<?= base_url('img/tiara.jpg') ?>" alt="Foto Tiara">
    </div>
</section>

<div class="grid">
    <div class="card">
        <h3>Biodata</h3>
        <p>Profil singkat, kontak, dan data pribadi.</p>
        <a href="/biodata">Buka biodata →</a>
    </div>
    <div class="card">
        <h3>Riwayat Pendidikan</h3>
        <p>Jejak sekolah.</p>
        <a href="/pendidikan">Lihat riwayat →</a>
    </div>
    <div class="card">
        <h3>Aktivitas Harian</h3>
        <p>Rutinitas sehari-hari.</p>
        <a href="/aktivitas">Telusuri aktivitas →</a>
    </div>
</div>

<footer>
    © <?= date('Y') ?> Tiara Cahya Kurniawati · Universitas Yatsi Madani
    <style>.eyebrow{letter-spacing:0.08em;text-transform:uppercase;font-size:12px;color:#fbcfe8;margin:0 0 10px;}</style>
</footer>

<script>
    const burger = document.querySelector('.burger');
    const drawer = document.getElementById('drawer');
    const closeBtn = drawer?.querySelector('.close-btn');

    function toggleDrawer(open) {
        if (!drawer) return;
        drawer.classList.toggle('open', open);
    }

    burger?.addEventListener('click', () => toggleDrawer(true));
    closeBtn?.addEventListener('click', () => toggleDrawer(false));
    drawer?.addEventListener('click', (e) => {
        if (e.target === drawer) toggleDrawer(false);
    });
</script>

</body>
</html>

