<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Pendidikan - Profil Tiara</title>
    <style>
        :root {
            --bg: #0e0a1f;
            --card: rgba(255, 255, 255, 0.06);
            --border: rgba(255, 255, 255, 0.12);
            --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            font-family: 'Segoe UI', system-ui, sans-serif;
            background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                        radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                        radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                        var(--bg);
            color: #e5e7eb;
            min-height: 100vh;
        }

        nav {
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px 32px;
            backdrop-filter: blur(16px);
            background: rgba(12, 10, 25, 0.7);
            border-bottom: 1px solid var(--border);
        }
        nav .logo { font-weight: 800; letter-spacing: 0.08em; color: #f8fafc; }
        nav a {
            margin-left: 16px;
            text-decoration: none;
            color: #e5e7eb;
            font-weight: 600;
            padding: 10px 14px;
            border-radius: 12px;
        }
        nav a:hover { background: rgba(255,255,255,0.08); }

        .layout {
            max-width: 900px;
            margin: 32px auto 80px;
            padding: 0 24px;
        }

        .card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 22px;
            padding: 26px;
            box-shadow: var(--glow);
            backdrop-filter: blur(12px);
        }

        h1 { margin: 0 0 8px; color: #f8fafc; }
        .subtitle { color: #cbd5e1; margin: 0 0 20px; }
        .eyebrow { letter-spacing: 0.08em; text-transform: uppercase; font-size: 12px; color: #fbcfe8; margin: 0 0 10px; }

        .filters {
            display: grid;
            grid-template-columns: 1fr 160px 110px;
            gap: 10px;
            margin: 14px 0 10px;
        }
        .filters input,
        .filters select,
        .filters button {
            padding: 12px 12px;
            border-radius: 12px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.05);
            color: #f8fafc;
        }
        .filters input::placeholder { color: #94a3b8; }
        .filters button {
            font-weight: 700;
            cursor: pointer;
            box-shadow: 0 10px 24px rgba(0,0,0,0.18);
            transition: filter 0.2s ease, transform 0.2s ease;
        }
        .filters button:hover { filter: brightness(1.05); transform: translateY(-1px); }
        .filters select option {
            color: #0f172a;
            background: #fff;
        }

        .timeline {
            position: relative;
            padding-left: 24px;
        }
        .timeline::before {
            content: '';
            position: absolute;
            top: 0;
            left: 6px;
            width: 2px;
            height: 100%;
            background: linear-gradient(180deg, rgba(236,72,153,0.4), rgba(139,92,246,0.4));
        }
        .item {
            position: relative;
            padding: 16px 16px 16px 26px;
            margin-bottom: 14px;
            border: 1px solid var(--border);
            border-radius: 14px;
            background: rgba(255,255,255,0.03);
            display: grid;
            grid-template-columns: auto 1fr;
            gap: 14px;
        }
        .item::before {
            content: '';
            position: absolute;
            width: 12px;
            height: 12px;
            background: linear-gradient(135deg, #ec4899, #8b5cf6);
            border-radius: 50%;
            left: -1px;
            top: 20px;
            box-shadow: var(--glow);
        }
        .item h3 { margin: 0 0 6px; color: #f8fafc; }
        .item .meta { color: #cbd5e1; margin: 0 0 8px; font-weight: 700; }
        .thumb {
            width: 82px;
            height: 82px;
            border-radius: 14px;
            object-fit: cover;
            border: 1px solid var(--border);
            box-shadow: var(--glow);
        }
        .thumb-placeholder {
            width: 82px;
            height: 82px;
            border-radius: 14px;
            border: 1px dashed var(--border);
            display: grid;
            place-items: center;
            color: #94a3b8;
            font-size: 12px;
        }

        footer {
            text-align: center;
            padding: 18px;
            color: #cbd5e1;
            border-top: 1px solid var(--border);
            background: rgba(12, 10, 25, 0.7);
        }

        @media (max-width: 720px) {
            nav { padding: 12px 18px; }
            .layout { padding: 0 18px; }
            .filters { grid-template-columns: 1fr; }
            .item { grid-template-columns: 1fr; }
            nav { flex-direction: column; align-items: flex-start; gap: 8px; }
            nav a { margin-left: 0; }
            .card { padding: 20px; }
            .thumb, .thumb-placeholder { width: 68px; height: 68px; }
        }
    </style>
</head>
<body>

<nav>
    <div class="logo">PROFIL TIARA</div>
    <div>
        <a href="/">Home</a>
        <a href="/biodata">Biodata</a>
        <a href="/pendidikan">Pendidikan</a>
        <a href="/aktivitas">Aktivitas</a>
    </div>
</nav>

<div class="layout">
    <div class="card">
        <p class="eyebrow">Riwayat Pendidikan</p>
        <h1>Jejak Belajar</h1>
        <p class="subtitle">Rangkuman jenjang pendidikan.</p>

        <form method="get" class="filters">
            <input type="text" name="keyword" value="<?= esc($keyword ?? '') ?>" placeholder="Cari jenjang atau sekolah...">
            <select name="sort" onchange="this.form.submit()">
                <option value="default" <?= (($sort ?? 'default') === 'default') ? 'selected' : '' ?>>Default</option>
                <option value="desc" <?= (($sort ?? '') === 'desc') ? 'selected' : '' ?>>Terbaru</option>
                <option value="asc" <?= (($sort ?? '') === 'asc') ? 'selected' : '' ?>>Terlama</option>
            </select>
            <button type="submit">Cari</button>
        </form>

        <div class="timeline">
            <?php if (empty($riwayat)): ?>
                <p class="subtitle">Belum ada data pendidikan.</p>
            <?php else: ?>
            <?php foreach (($riwayat ?? []) as $item): ?>
                <div class="item">
                    <?php if (!empty($item['foto'])): ?>
                        <img src="<?= base_url('uploads/pendidikan/'.$item['foto']) ?>" alt="Foto <?= esc($item['jenjang']) ?>" class="thumb">
                    <?php else: ?>
                        <div class="thumb-placeholder">Tidak ada foto</div>
                    <?php endif; ?>
                    <div>
                        <h3><?= esc($item['jenjang']) ?></h3>
                        <p class="meta"><?= esc($item['nama_sekolah']) ?> · <?= esc($item['tahun_mulai']) ?> - <?= esc($item['tahun_selesai']) ?></p>
                        <?php if (!empty($item['keterangan'])): ?>
                            <p><?= esc($item['keterangan']) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<footer>
    © <?= date('Y') ?> Tiara Cahya Kurniawati · Universitas Yatsi Madani
</footer>

</body>
</html>
